/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.album;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import net.fichotheque.album.Album;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class AlbumAttributeChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "AlbumAttributeChange";
    public static final String COMMANDKEY = "_ ALB-09";
    public static final String ATTRIBUTES_PARAMNAME = "attributes";
    private Album album;
    private AttributeChange attributeChange;

    public AlbumAttributeChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("album", COMMANDNAME);){
            session.getFichothequeEditor().changeAttributes(this.album.getAlbumMetadata(), this.attributeChange);
        }
        this.putResultObject("obj.album", this.album);
        this.setDone("_ done.global.attributechange", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.album = this.requestHandler.getMandatoryAlbum();
        this.checkSubsetAdmin(this.album);
        String attributes = this.getMandatory(ATTRIBUTES_PARAMNAME);
        this.attributeChange = AttributeParser.parse(attributes);
    }
}

