/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.administration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.diagnostic.urlscan.UrlInfo;
import fr.exemole.bdfserver.tools.diagnostic.urlscan.UrlScanEngine;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import java.util.Collection;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class UrlScanCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "UrlScan";
    public static final String FICHES_PARAMNAME = "fiches";
    public static final String ALL_FICHES_PARAMVALUE = "all";
    public static final String SELECTION_FICHES_PARAMVALUE = "selection";
    private boolean all = false;

    public UrlScanCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        Collection<UrlInfo> infos = this.all ? UrlScanEngine.run(this.bdfServer).values() : UrlScanEngine.run(this.bdfServer, this.bdfUser.getSelectedFiches()).values();
        this.putResultObject("obj.urlinfocollection", infos);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        String fiches = this.requestHandler.getTrimedParameter(FICHES_PARAMNAME);
        if (fiches.equals(ALL_FICHES_PARAMVALUE)) {
            this.all = true;
        }
    }
}

