/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.administration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfCommand;
import fr.exemole.bdfserver.commands.administration.BackupCommand;
import fr.exemole.bdfserver.commands.administration.BackupDeleteCommand;
import fr.exemole.bdfserver.commands.administration.NewAppCommand;
import fr.exemole.bdfserver.commands.administration.ResourceCreationCommand;
import fr.exemole.bdfserver.commands.administration.ResourceRemoveCommand;
import fr.exemole.bdfserver.commands.administration.ResourceUploadCommand;
import fr.exemole.bdfserver.commands.administration.RoleChangeCommand;
import fr.exemole.bdfserver.commands.administration.RoleCreationCommand;
import fr.exemole.bdfserver.commands.administration.RoleRemoveCommand;
import fr.exemole.bdfserver.commands.administration.StreamTextChangeCommand;
import fr.exemole.bdfserver.commands.administration.UrlScanCommand;
import fr.exemole.bdfserver.commands.administration.UrlTestCommand;
import net.mapeadores.util.request.RequestMap;

public final class AdministrationCommandFactory {
    private AdministrationCommandFactory() {
    }

    public static BdfCommand getBdfCommand(BdfServer bdfServer, RequestMap requestMap, String commandName) {
        switch (commandName) {
            case "Backup": {
                return new BackupCommand(bdfServer, requestMap);
            }
            case "BackupDelete": {
                return new BackupDeleteCommand(bdfServer, requestMap);
            }
            case "RoleChange": {
                return new RoleChangeCommand(bdfServer, requestMap);
            }
            case "RoleCreation": {
                return new RoleCreationCommand(bdfServer, requestMap);
            }
            case "RoleRemove": {
                return new RoleRemoveCommand(bdfServer, requestMap);
            }
            case "StreamTextChange": {
                return new StreamTextChangeCommand(bdfServer, requestMap);
            }
            case "ResourceCreation": {
                return new ResourceCreationCommand(bdfServer, requestMap);
            }
            case "ResourceRemove": {
                return new ResourceRemoveCommand(bdfServer, requestMap);
            }
            case "ResourceUpload": {
                return new ResourceUploadCommand(bdfServer, requestMap);
            }
            case "NewApp": {
                return new NewAppCommand(bdfServer, requestMap);
            }
            case "UrlScan": {
                return new UrlScanCommand(bdfServer, requestMap);
            }
            case "UrlTest": {
                return new UrlTestCommand(bdfServer, requestMap);
            }
        }
        return null;
    }
}

