/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.addenda;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.Document;
import net.fichotheque.tools.FichothequeTools;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class DocumentRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "DocumentRemove";
    public static final String COMMANDKEY = "_ ADD-06";
    private Document document;

    public DocumentRemoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        Addenda addenda = this.document.getAddenda();
        try (EditSession session = this.startEditSession("addenda", COMMANDNAME);){
            FichothequeTools.remove(session.getFichothequeEditor(), this.document);
        }
        this.putResultObject("obj.addenda", addenda);
        this.setDone("_ done.addenda.documentremove", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.document = this.requestHandler.getMandatoryDocument();
        this.getPermissionChecker().checkWrite(this.document);
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_remove");
        }
    }
}

