/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.api.namespaces;

import net.fichotheque.permission.PermissionSummary;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.attr.CheckedNameSpace;

public final class RoleSpace {
    public static final CheckedNameSpace ROLE_NAMESPACE = CheckedNameSpace.build("role");
    public static final AttributeKey READ_KEY = AttributeKey.build(ROLE_NAMESPACE, "read");
    public static final AttributeKey WRITE_KEY = AttributeKey.build(ROLE_NAMESPACE, "write");

    private RoleSpace() {
    }

    public static boolean canRead(PermissionSummary permissionSummary, Attributes attributes) {
        if (permissionSummary.isFichothequeAdmin()) {
            return true;
        }
        Attribute attribute = attributes.getAttribute(READ_KEY);
        if (attribute == null) {
            return true;
        }
        for (String value : attribute) {
            if (!permissionSummary.hasRole(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean canWrite(PermissionSummary permissionSummary, Attributes attributes) {
        if (permissionSummary.isFichothequeAdmin()) {
            return true;
        }
        if (!RoleSpace.canRead(permissionSummary, attributes)) {
            return false;
        }
        Attribute attribute = attributes.getAttribute(WRITE_KEY);
        if (attribute == null) {
            return true;
        }
        for (String value : attribute) {
            if (!permissionSummary.hasRole(value)) continue;
            return true;
        }
        return false;
    }
}

