/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.api.instruction;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.PermissionException;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.roles.PermissionCheck;
import java.util.Locale;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.addenda.Document;
import net.fichotheque.album.Illustration;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.tools.extraction.builders.ExtractionContextBuilder;
import net.mapeadores.util.html.HtmlCleaner;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;

public interface BdfParameters {
    public BdfServer getBdfServer();

    public BdfUser getBdfUser();

    public PermissionSummary getPermissionSummary();

    default public Fichotheque getFichotheque() {
        return this.getBdfServer().getFichotheque();
    }

    default public Lang getWorkingLang() {
        return this.getBdfUser().getWorkingLang();
    }

    default public Locale getFormatLocale() {
        return this.getBdfUser().getFormatLocale();
    }

    default public HtmlCleaner getHtmlCleaner() {
        return this.getBdfServer().getHtmlCleaner();
    }

    default public MessageLocalisation getMessageLocalisation() {
        return this.getBdfServer().getL10nManager().getMessageLocalisation(this.getBdfUser());
    }

    default public boolean isFichothequeAdmin() {
        return this.getBdfServer().getPermissionManager().isAdmin(this.getBdfUser().getRedacteur());
    }

    default public void checkFichothequeAdmin() throws PermissionException {
        if (!this.isFichothequeAdmin()) {
            throw BdfErrors.permission("_ error.permission.admin", new Object[0]);
        }
    }

    default public void checkSubsetAdmin(Subset subset) throws PermissionException {
        PermissionCheck.checkSubsetAdmin(this.getPermissionSummary(), subset);
    }

    default public void checkSubsetAccess(Subset subset) throws PermissionException {
        PermissionCheck.checkSubsetAccess(this.getPermissionSummary(), subset);
    }

    default public void checkWrite(SubsetItem subsetItem) throws PermissionException {
        PermissionSummary permissionSummary = this.getPermissionSummary();
        if (subsetItem instanceof FicheMeta) {
            PermissionCheck.checkWrite(permissionSummary, (FicheMeta)subsetItem);
        } else if (subsetItem instanceof Illustration) {
            PermissionCheck.checkWrite(permissionSummary, (Illustration)subsetItem);
        } else if (subsetItem instanceof Document) {
            PermissionCheck.checkWrite(permissionSummary, (Document)subsetItem);
        }
    }

    default public void checkRead(SubsetItem subsetItem) throws PermissionException {
        PermissionSummary permissionSummary = this.getPermissionSummary();
        if (subsetItem instanceof FicheMeta) {
            PermissionCheck.checkRead(permissionSummary, (FicheMeta)subsetItem);
        }
    }

    default public void checkSphereSupervisor(String sphereName) throws PermissionException {
        PermissionCheck.checkSphereSupervisor(this.getBdfServer(), this.getBdfUser(), sphereName);
    }

    default public ExtractionContextBuilder getExtractionContextBuilder() {
        return BdfServerUtils.initExtractionContextBuilder(this.getBdfServer(), this.getBdfUser(), this.getPermissionSummary());
    }

    default public ExtractionContext getDefaultExtractionContext() {
        return this.getExtractionContextBuilder().toExtractionContext();
    }

    default public Map<String, String> getStoredValues(String storeName) {
        return this.getBdfServer().getStoredValues(this.getBdfUser(), storeName);
    }
}

