/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.utils.instructions;

import fr.exemole.bdfext.utils.instructions.UtilsInstruction;
import fr.exemole.bdfext.utils.instructions.UtilsInstructionException;
import fr.exemole.bdfserver.api.EditSession;
import java.util.HashSet;
import java.util.List;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.NoRemoveableSubsetException;
import net.fichotheque.SubsetItem;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.AddendaEditor;
import net.fichotheque.addenda.Document;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.tools.FichothequeTools;
import net.fichotheque.utils.CorpusUtils;

public class NettoyageSelection
extends UtilsInstruction {
    private FichothequeEditor fichothequeEditor;
    private int removedCorpus = 0;
    private int removedFiches = 0;
    private int removedDocument = 0;

    @Override
    public Object runInstruction() {
        try (EditSession editSession = this.bdfServer.initEditSession(this.bdfUser, "ext:Utils/NettoyageSelection");){
            this.fichothequeEditor = editSession.getFichothequeEditor();
            Fiches fiches = this.bdfUser.getSelectedFiches();
            for (Corpus corpus : this.fichotheque.getCorpusList()) {
                List selectionList = CorpusUtils.getFicheMetaListByCorpus((Fiches)fiches, (Corpus)corpus);
                if (selectionList.isEmpty()) {
                    this.removeCorpus(corpus);
                    continue;
                }
                this.removeFiches(corpus, selectionList);
            }
            for (Addenda addenda : this.fichotheque.getAddendaList()) {
                AddendaEditor addendaEditor = this.fichothequeEditor.getAddendaEditor(addenda);
                for (Document document : addenda.getDocumentList()) {
                    if (!this.fichotheque.isRemoveable((SubsetItem)document)) continue;
                    addendaEditor.removeDocument(document);
                    ++this.removedDocument;
                }
            }
        }
        return "Corpus supprim\u00e9 : " + this.removedCorpus + " / Fiches supprim\u00e9es : " + this.removedFiches + " / Documents supprim\u00e9s : " + this.removedDocument;
    }

    public void removeCorpus(Corpus corpus) {
        for (FicheMeta ficheMeta : corpus.getFicheMetaList()) {
            FichothequeTools.remove((FichothequeEditor)this.fichothequeEditor, (FicheMeta)ficheMeta);
            ++this.removedFiches;
        }
        try {
            this.fichothequeEditor.removeCorpus(corpus);
        }
        catch (NoRemoveableSubsetException nrse) {
            throw new UtilsInstructionException(nrse.getMessage());
        }
        ++this.removedCorpus;
    }

    public void removeFiches(Corpus corpus, List<FicheMeta> selectionList) {
        HashSet<Integer> ficheidSet = new HashSet<Integer>();
        for (FicheMeta ficheMeta : selectionList) {
            ficheidSet.add(ficheMeta.getId());
        }
        for (FicheMeta ficheMeta : corpus.getFicheMetaList()) {
            if (ficheidSet.contains(ficheMeta.getId())) continue;
            FichothequeTools.remove((FichothequeEditor)this.fichothequeEditor, (FicheMeta)ficheMeta);
            ++this.removedFiches;
        }
    }
}

