/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique.detail;

import fr.exemole.bdfext.scarabe.api.analytique.MoneyByCurrency;
import fr.exemole.bdfext.scarabe.api.core.Avenir;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.api.cours.CoursManager;
import fr.exemole.bdfext.scarabe.tools.MutableMoneyByCurrency;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import fr.exemole.bdfext.scarabe.tools.analytique.ConversionEngineParameters;
import fr.exemole.bdfext.scarabe.tools.analytique.detail.DetailEngine;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.money.CurrenciesUtils;
import net.mapeadores.util.money.ExtendedCurrency;

class ConversionDetailEngine
extends DetailEngine {
    private final ExtendedCurrency pivotCurrency;
    private final CoursManager coursManager;
    private final Currencies customCurrencies;

    public ConversionDetailEngine(ConversionEngineParameters conversionEngineParameters) {
        this.coursManager = conversionEngineParameters.getCoursManager();
        this.pivotCurrency = conversionEngineParameters.getPivotCurrency();
        this.customCurrencies = CurrenciesUtils.wrap((ExtendedCurrency[])new ExtendedCurrency[]{this.pivotCurrency});
    }

    @Override
    public MoneyByCurrency toMoneyByCurrency(Ligne ligne) {
        long lg = AnalytiqueUtils.convert(this.coursManager, this.pivotCurrency, ligne);
        return new InternalMoneyByCurrency(lg);
    }

    @Override
    public MoneyByCurrency toMoneyByCurrency(Avenir avenir) {
        long lg = AnalytiqueUtils.convert(this.coursManager, this.pivotCurrency, avenir);
        return new InternalMoneyByCurrency(lg);
    }

    @Override
    public MutableMoneyByCurrency getMutableMoneyByCurrency() {
        return new MutableMoneyByCurrency(1);
    }

    @Override
    public Currencies getCustomCurrencies() {
        return this.customCurrencies;
    }

    private static class InternalMoneyByCurrency
    implements MoneyByCurrency {
        private final long moneyLong;

        private InternalMoneyByCurrency(long moneyLong) {
            this.moneyLong = moneyLong;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean withMoney(int currencyIndex) {
            return currencyIndex == 0;
        }

        @Override
        public long getMoneyLong(int currencyIndex) {
            if (currencyIndex == 0) {
                return this.moneyLong;
            }
            return 0L;
        }
    }
}

