/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.producers.html;

import fr.exemole.bdfext.scarabe.Scarabe;
import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.ScarabeSpace;
import fr.exemole.bdfext.scarabe.api.Recapitulatif;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueSubset;
import fr.exemole.bdfext.scarabe.api.analytique.Prerequest;
import fr.exemole.bdfext.scarabe.api.analytique.PrerequestDef;
import fr.exemole.bdfext.scarabe.api.cours.CoursManager;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.consumers.Tree;
import fr.exemole.bdfserver.tools.BH;
import fr.exemole.bdfserver.tools.BdfHref;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.fichotheque.Subset;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlWrapper;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.money.ExtendedCurrency;

public class RecapitulatifHtmlProducer
extends BdfServerHtmlProducer {
    private static final HtmlWrapper TREE = Tree.tree((String)"scarabe-index-Tree");
    private static final HtmlWrapper LEAF = Tree.leaf((String)"scarabe-index-Leaf");
    private final ScarabeContext scarabeContext;

    public RecapitulatifHtmlProducer(BdfParameters bdfParameters, ScarabeContext scarabeContext) {
        super(bdfParameters);
        this.scarabeContext = scarabeContext;
        this.setBodyCssClass("global-body-ListFrame");
        this.addExtensionThemeCss("scarabe", new String[]{"index.css"});
    }

    public void printHtml() {
        Recapitulatif recapitulatif = this.scarabeContext.getScarabeCache().getRecapitulatif(this.bdfServer);
        this.start();
        if (recapitulatif.hasGlobalErrors()) {
            this.__(PageUnit.SIMPLE, () -> this.P().SPAN("global-ErrorMessage").__localize(recapitulatif.getGlobalErrorMessage())._SPAN()._P());
            this.end();
        }
        this.__(this.printMessages(recapitulatif)).__(this.printBanquesUnit(recapitulatif)).__(this.printRepartitionUnit(recapitulatif)).__(this.printAvancesUnit(recapitulatif)).__(this.printDepensesUnit(recapitulatif));
        this.end();
    }

    private boolean printMessages(Recapitulatif recapitulatif) {
        if (!recapitulatif.hasErrors() && recapitulatif.getResteWarningMouvementList().isEmpty() && recapitulatif.getPastDateWarningAvenirList().isEmpty() && recapitulatif.getErrorAnalytiqueSubsetList().isEmpty()) {
            return false;
        }
        this.__(PageUnit.SIMPLE, () -> {
            if (recapitulatif.hasErrors()) {
                this.P().SPAN("global-ErrorMessage").__localize("_ warning.scarabe.recapitulatiferrors")._SPAN().BR().SPAN("global-SmallLinks").A(HA.href((CharSequence)BH.domain((String)Scarabe.DOMAIN).page("ErrorRecapitulatif"))).__localize("_ link.scarabe.errorrecapitulatif")._A()._SPAN()._P();
            }
            if (!recapitulatif.getResteWarningMouvementList().isEmpty()) {
                this.P().SPAN("scarabe-index-Warning").__localize("_ warning.scarabe.restewarning")._SPAN().BR().SPAN("global-SmallLinks").A(HA.href((CharSequence)BH.domain((String)Scarabe.DOMAIN).page("ResteWarning"))).__localize("_ link.scarabe.restewarning")._A()._SPAN()._P();
            }
            if (!recapitulatif.getPastDateWarningAvenirList().isEmpty()) {
                this.P().SPAN("scarabe-index-Warning").__localize("_ warning.scarabe.pastdatewarning")._SPAN().BR().SPAN("global-SmallLinks").A(HA.href((CharSequence)BH.domain((String)Scarabe.DOMAIN).page("PastDateWarning"))).__localize("_ link.scarabe.pastdatewarning")._A()._SPAN()._P();
            }
            if (!recapitulatif.getErrorAnalytiqueSubsetList().isEmpty()) {
                this.P().SPAN("global-ErrorMessage").__localize("_ warning.scarabe.analytiquesubseterrors")._SPAN().BR()._P();
            }
        });
        return true;
    }

    private boolean printBanquesUnit(Recapitulatif recapitulatif) {
        this.__((Consumer)PageUnit.startDetails((Object)"_ title.scarabe.banques", (boolean)true)).P().A(HA.href((CharSequence)BH.domain((String)Scarabe.DOMAIN).page("BanqueRecapitulatif"))).__localize("_ link.scarabe.banquerecapitulatif")._A()._P().__(PageUnit.END_DETAILS);
        return true;
    }

    private boolean printRepartitionUnit(Recapitulatif recapitulatif) {
        if (recapitulatif.getAnalytiqueSubsetList().isEmpty() && recapitulatif.getErrorAnalytiqueSubsetList().isEmpty()) {
            return false;
        }
        CoursManager coursManager = recapitulatif.getCoursManager();
        Currencies pivotCurrencies = coursManager != null ? coursManager.getPivotCurrencies() : null;
        this.__((Consumer)PageUnit.startDetails((Object)"_ title.scarabe.analytiquerepartition", (boolean)true)).__(this.printErrors(recapitulatif)).DL("scarabe-index-SubsetDL");
        for (AnalytiqueSubset analytiqueSubset : recapitulatif.getAnalytiqueSubsetList()) {
            Subset subset = analytiqueSubset.getSubset();
            this.DT().__escape((CharSequence)FichothequeUtils.getTitle((Subset)subset, (Lang)this.workingLang))._DT().DD().__(TREE, () -> {
                if (analytiqueSubset.hasWarning()) {
                    for (Message message : analytiqueSubset.getWarningList()) {
                        this.__(LEAF, () -> this.SPAN("scarabe-index-Warning").__localize(warningMessage)._SPAN());
                    }
                }
                this.__(LEAF, () -> {
                    BdfHref allHref = this.recapHref(subset);
                    this.A(HA.href((CharSequence)allHref)).__localize("_ link.scarabe.analytique_all")._A().__(this.printConversionLink(allHref, pivotCurrencies));
                }).__(LEAF, () -> {
                    BdfHref selectionHref = this.recapHref(subset).param("selection", "1");
                    this.A(HA.href((CharSequence)selectionHref)).__localize("_ link.scarabe.analytique_selection")._A().__(this.printConversionLink(selectionHref, pivotCurrencies));
                });
                for (Prerequest prerequest : analytiqueSubset.getPrerequestList()) {
                    PrerequestDef prerequestDef = prerequest.getPrerequestDef();
                    BdfHref prerequestHref = this.recapHref(subset);
                    String include = RecapitulatifHtmlProducer.toString(prerequest.getIncludeIdSet());
                    String exclude = RecapitulatifHtmlProducer.toString(prerequest.getExcludeIdSet());
                    if (include.length() > 0) {
                        prerequestHref.param("include", include);
                    }
                    if (exclude.length() > 0) {
                        prerequestHref.param("exclude", exclude);
                    }
                    this.checkAttributes(prerequestHref, prerequestDef.getAttributes());
                    this.__(Tree.LEAF, () -> this.A(HA.href((CharSequence)prerequestHref)).__escape((CharSequence)prerequestDef.getTitle(this.workingLang))._A().__(this.printConversionLink(prerequestHref, pivotCurrencies)));
                }
            });
            this._DD();
        }
        this._DL().__(PageUnit.END_DETAILS);
        return true;
    }

    private boolean printErrors(Recapitulatif recapitulatif) {
        List<AnalytiqueSubset> list = recapitulatif.getErrorAnalytiqueSubsetList();
        if (list.isEmpty()) {
            return false;
        }
        this.DL("scarabe-index-SubsetDL");
        for (AnalytiqueSubset analytiqueSubset : recapitulatif.getErrorAnalytiqueSubsetList()) {
            Subset subset = analytiqueSubset.getSubset();
            this.DT().SPAN("global-ErrorMessage").__escape((CharSequence)FichothequeUtils.getTitle((Subset)subset, (Lang)this.workingLang))._SPAN()._DT().DD().__(TREE, () -> {
                for (Message message : analytiqueSubset.getErrorList()) {
                    this.__(LEAF, () -> this.SPAN("global-ErrorMessage").__localize(errorMessage)._SPAN());
                }
                if (analytiqueSubset.hasWarning()) {
                    for (Message message : analytiqueSubset.getWarningList()) {
                        this.__(LEAF, () -> this.SPAN("scarabe-index-Warning").__localize(warningMessage)._SPAN());
                    }
                }
            })._DD();
        }
        this._DL();
        return true;
    }

    private boolean printAvancesUnit(Recapitulatif recapitulatif) {
        this.__((Consumer)PageUnit.startDetails((Object)"_ title.scarabe.avances", (boolean)true));
        int nonSoldee = recapitulatif.getAvanceNonSoldeeList().size();
        this.P();
        if (nonSoldee == 0) {
            this.__localize("_ label.scarabe.avancenonsoldeecount").__colon().__escape((CharSequence)this.bdfUser.format(nonSoldee));
        } else {
            this.A(HA.href((CharSequence)BH.domain((String)Scarabe.DOMAIN).page("AvancesNonSoldees"))).__localize("_ label.scarabe.avancenonsoldeecount").__colon().__escape((CharSequence)this.bdfUser.format(nonSoldee))._A();
        }
        this._P().__(PageUnit.END_DETAILS);
        return true;
    }

    private boolean printDepensesUnit(Recapitulatif recapitulatif) {
        this.__((Consumer)PageUnit.startDetails((Object)"_ title.scarabe.depenses", (boolean)true));
        int depenseAvenir = recapitulatif.getAvenirList().size();
        this.P();
        if (depenseAvenir == 0) {
            this.__localize("_ label.scarabe.depenseavenircount").__colon().__escape((CharSequence)this.bdfUser.format(depenseAvenir));
        } else {
            this.A(HA.href((CharSequence)BH.domain((String)Scarabe.DOMAIN).page("DepenseAvenir"))).__localize("_ label.scarabe.depenseavenircount").__colon().__escape((CharSequence)this.bdfUser.format(depenseAvenir))._A();
        }
        this._P().__(PageUnit.END_DETAILS);
        return true;
    }

    private boolean printConversionLink(BdfHref href, Currencies pivotCurrencies) {
        if (pivotCurrencies == null) {
            return false;
        }
        this.__space().SPAN("global-SmallLinks").__escape('(');
        int length = pivotCurrencies.size();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                this.__dash();
            }
            String curString = ((ExtendedCurrency)pivotCurrencies.get(i)).getCurrencyCode();
            this.A(HA.href((CharSequence)href.derive("conversion", curString))).__escape((CharSequence)curString)._A();
        }
        this.__escape(')')._SPAN();
        return true;
    }

    private BdfHref recapHref(Subset subset) {
        return BH.domain((String)Scarabe.DOMAIN).command("AnalytiqueRecap").page("AnalytiqueRecapList").param("subset", subset.getSubsetKeyString());
    }

    private void checkAttributes(BdfHref bdfHref, Attributes attributes) {
        if (attributes.isTrue(ScarabeSpace.HIDE_ROOT)) {
            bdfHref.param("hide_root", "1");
        }
    }

    private static String toString(Set<Integer> idSet) {
        if (idSet.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (Integer itg : idSet) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(itg);
        }
        return buf.toString();
    }
}

