/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.json;

import fr.exemole.bdfext.scarabe.ScarabeLocalisation;
import fr.exemole.bdfext.scarabe.api.analytique.Agregat;
import fr.exemole.bdfext.scarabe.api.analytique.AgregatUnit;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueRecap;
import fr.exemole.bdfext.scarabe.api.analytique.CustomLigneDef;
import fr.exemole.bdfext.scarabe.api.analytique.MoneyByCurrency;
import fr.exemole.bdfext.scarabe.api.analytique.MoneyChronology;
import fr.exemole.bdfext.scarabe.api.analytique.Operation;
import fr.exemole.bdfext.scarabe.api.analytique.OperationDef;
import fr.exemole.bdfext.scarabe.api.analytique.SoldeDef;
import fr.exemole.bdfext.scarabe.json.JsonUtils;
import fr.exemole.bdfext.scarabe.tools.ScarabeUtils;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import java.io.IOException;
import net.fichotheque.SubsetItem;
import net.fichotheque.exportation.table.Cell;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.json.CellJson;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.json.CommonJson;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.money.Currencies;

public final class AnalytiqueRecapJson {
    private AnalytiqueRecapJson() {
    }

    public static void properties(JSONWriter jw, AnalytiqueRecap analytiqueRecap, ScarabeLocalisation scarabeLocalisation, CellConverter cellConverter) throws IOException {
        if (!analytiqueRecap.isRoot()) {
            Object recapObject = analytiqueRecap.getRecapObject();
            SubsetItem subsetItem = ScarabeUtils.getSubsetItem(recapObject);
            if (subsetItem != null) {
                JsonUtils.properties(jw, subsetItem, scarabeLocalisation, cellConverter);
            } else {
                jw.key("title").value((Object)ScarabeUtils.getLibelle(recapObject, scarabeLocalisation.getWorkingLang()));
            }
        }
        AnalytiqueRecapJson.operationsProperty(jw, analytiqueRecap, scarabeLocalisation, cellConverter);
        AnalytiqueRecapJson.chronologyProperty(jw, analytiqueRecap);
        jw.key("subArray");
        jw.array();
        for (AnalytiqueRecap sub : analytiqueRecap.getSubRecapList()) {
            jw.object();
            AnalytiqueRecapJson.properties(jw, sub, scarabeLocalisation, cellConverter);
            jw.endObject();
        }
        jw.endArray();
    }

    public static void chronologyProperty(JSONWriter jw, AnalytiqueRecap analytiqueRecap) throws IOException {
        Currencies currencies = analytiqueRecap.getCurrencies();
        jw.key("chronology");
        jw.object();
        jw.key("years");
        jw.array();
        for (AnalytiqueRecap.Year year : analytiqueRecap.getYearList()) {
            jw.object();
            jw.key("year").value((long)year.getYear());
            jw.endObject();
        }
        jw.endArray();
        AnalytiqueRecapJson.subchronologyProperty(jw, "ligne", analytiqueRecap.getLigneMoneyChronology(), currencies);
        AnalytiqueRecapJson.subchronologyProperty(jw, "depense", analytiqueRecap.getDepenseMoneyChronology(), currencies);
        AnalytiqueRecapJson.subchronologyProperty(jw, "apport", analytiqueRecap.getApportMoneyChronology(), currencies);
        AnalytiqueRecapJson.subchronologyProperty(jw, "avance", analytiqueRecap.getAvanceMoneyChronology(), currencies);
        AnalytiqueRecapJson.subchronologyProperty(jw, "avenir", analytiqueRecap.getAvenirMoneyChronology(), currencies);
        jw.endObject();
    }

    public static void operationsProperty(JSONWriter jw, AnalytiqueRecap analytiqueRecap, ScarabeLocalisation scarabeLocalisation, CellConverter cellConverter) throws IOException {
        Lang lang = scarabeLocalisation.getWorkingLang();
        MessageLocalisation messageLocalisation = scarabeLocalisation.getMessageLocalisation();
        Currencies currencies = analytiqueRecap.getCurrencies();
        jw.key("operations");
        jw.array();
        for (Operation operation : analytiqueRecap.getOperationList()) {
            MoneyByCurrency moneyByCurrency = operation.getMoneyByCurrency();
            if (moneyByCurrency.isEmpty()) continue;
            OperationDef operationDef = operation.getOperationDef();
            jw.object();
            jw.key("name").value((Object)operationDef.getName());
            jw.key("title");
            if (!operationDef.getTitleLabels().isEmpty()) {
                jw.value((Object)operationDef.getTitle(lang));
            } else {
                String value = null;
                if (operationDef instanceof SoldeDef) {
                    value = messageLocalisation.toString("_ label.scarabe.solde");
                } else if (operationDef instanceof CustomLigneDef) {
                    value = messageLocalisation.toString(AnalytiqueUtils.getLibelleKey(operationDef.getName()));
                }
                if (value != null) {
                    jw.value((Object)value);
                } else {
                    jw.value((Object)operationDef.getName());
                }
            }
            jw.key("attributes");
            CommonJson.object((JSONWriter)jw, (Attributes)operationDef.getAttributes());
            JsonUtils.properties(jw, moneyByCurrency, currencies);
            if (operation instanceof Agregat) {
                jw.key("units");
                jw.array();
                for (AgregatUnit unit : ((Agregat)operation).getUnitList()) {
                    SubsetItem subsetItem = unit.getSubsetItem();
                    jw.object();
                    jw.key("subset").value((Object)subsetItem.getSubsetKey().getKeyString());
                    jw.key("id").value((long)subsetItem.getId());
                    JsonUtils.properties(jw, unit.getMoneyByCurrency(), currencies);
                    CellJson.cellArrayMappingProperty((JSONWriter)jw, (Cell[])cellConverter.toCellArray(subsetItem));
                    jw.endObject();
                }
                jw.endArray();
            }
            jw.endObject();
        }
        jw.endArray();
    }

    private static void subchronologyProperty(JSONWriter jw, String name, MoneyChronology chronology, Currencies currencies) throws IOException {
        if (chronology.getMoneyByCurrency().isEmpty()) {
            return;
        }
        jw.key(name);
        jw.object();
        JsonUtils.properties(jw, chronology.getMoneyByCurrency(), currencies);
        jw.key("years");
        jw.array();
        for (MoneyChronology.Year year : chronology.getYearList()) {
            jw.object();
            jw.key("year").value((long)year.getYear());
            JsonUtils.properties(jw, year.getMoneyByCurrency(), currencies);
            jw.key("months");
            jw.array();
            for (MoneyChronology.Month month : year.getMonthList()) {
                jw.object();
                jw.key("month").value((long)month.getMonth());
                JsonUtils.properties(jw, month.getMoneyByCurrency(), currencies);
                jw.endObject();
            }
            jw.endArray();
            jw.endObject();
        }
        jw.endArray();
        jw.endObject();
    }
}

