/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.commands;

import fr.exemole.bdfext.scarabe.Scarabe;
import fr.exemole.bdfext.scarabe.ScarabeBdfExtensionInitializer;
import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.tools.installation.InstallationEngine;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.IOException;
import java.io.InputStream;
import net.fichotheque.tools.alias.AliasDOMReader;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Document;

public class InstallationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "Installation";
    public static final String COMMANDKEY = "_ SCARABE-01";
    private final ScarabeContext scarabeContext;
    private AliasDOMReader coreAliasDOMReader;
    private Langs langs;
    private MessageLocalisation[] messageLocalisationArray;

    public InstallationCommand(BdfServer bdfServer, RequestMap requestMap, ScarabeContext scarabeContext) {
        super(bdfServer, requestMap);
        this.scarabeContext = scarabeContext;
    }

    public boolean needSynchronisation() {
        return true;
    }

    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession(Scarabe.DOMAIN, COMMANDNAME);){
            InstallationEngine.run(session, (BdfParameters)this);
            this.scarabeContext.reinit();
        }
        this.setDone("_ done.scarabe.installation", new Object[0]);
    }

    protected void checkParameters() throws ErrorMessageException {
        if (this.scarabeContext.getInitState() != 2) {
            throw BdfErrors.internalError((String)"Scarabe d\u00e9j\u00e0 install\u00e9");
        }
        this.coreAliasDOMReader = this.readAlias("scarabe-alias-core.xml");
        this.langs = this.bdfServer.getLangConfiguration().getWorkingLangs();
        int length = this.langs.size();
        this.messageLocalisationArray = new MessageLocalisation[length];
        for (int i = 0; i < length; ++i) {
            this.messageLocalisationArray[i] = this.bdfServer.getL10nManager().getMessageLocalisation((Lang)this.langs.get(i));
        }
    }

    private AliasDOMReader readAlias(String resourceName) {
        AliasDOMReader aliasDOMReader;
        block8: {
            InputStream is = ScarabeBdfExtensionInitializer.class.getResourceAsStream("tools/defaultfiles/" + resourceName);
            try {
                Document document = DOMUtils.readDocument((InputStream)is);
                AliasDOMReader reader = new AliasDOMReader(null);
                reader.readAlias(document.getDocumentElement());
                aliasDOMReader = reader;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new NestedIOException(ioe);
                }
            }
            is.close();
        }
        return aliasDOMReader;
    }
}

