/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.resourcesupdate.tools.conversion.zip;

import fr.exemole.bdfext.resourcesupdate.api.conversion.Conversion;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.text.Label;

public final class PropertiesConversionZipEngine {
    private PropertiesConversionZipEngine() {
    }

    public static void zip(Conversion conversion, ZipOutputStream zipOutputStream, String rootPath) throws IOException {
        String conversionName = conversion.getName();
        int thesaurusInfoCount = conversion.getThesaurusInfoCount();
        for (int i = 0; i < thesaurusInfoCount; ++i) {
            Conversion.ThesaurusInfo thesaurusInfo = conversion.getThesaurusInfo(i);
            String alias = thesaurusInfo.getAlias();
            if (alias == null) {
                alias = thesaurusInfo.getThesaurus().getSubsetName();
            }
            ThesaurusBuffer thesaurusBuffer = PropertiesConversionZipEngine.toThesaurusBuffer(thesaurusInfo);
            int length = thesaurusBuffer.langs.size();
            for (int j = 0; j < length; ++j) {
                Lang lang = (Lang)thesaurusBuffer.langs.get(j);
                String content = thesaurusBuffer.bufArray[j].toString();
                if (content.length() <= 0) continue;
                ZipEntry zipEntry = new ZipEntry(rootPath + conversionName + "/" + alias + "_" + lang.toString() + ".properties");
                zipOutputStream.putNextEntry(zipEntry);
                IOUtils.write((String)content, (OutputStream)zipOutputStream, (String)"ISO8859_1");
            }
        }
    }

    private static ThesaurusBuffer toThesaurusBuffer(Conversion.ThesaurusInfo thesaurusInfo) {
        Thesaurus thesaurus = thesaurusInfo.getThesaurus();
        Langs langs = thesaurusInfo.getLangs();
        int length = langs.size();
        StringBuilder[] bufArray = new StringBuilder[length];
        for (int i = 0; i < length; ++i) {
            bufArray[i] = new StringBuilder();
        }
        ThesaurusBuffer thesaurusBuffer = new ThesaurusBuffer(langs, bufArray);
        Motcle motcle = ThesaurusUtils.getFirst((Thesaurus)thesaurus);
        if (motcle != null) {
            PropertiesConversionZipEngine.bufMotcle(thesaurusBuffer, motcle);
        }
        return thesaurusBuffer;
    }

    private static void bufMotcle(ThesaurusBuffer thesaurusBuffer, Motcle motcle) {
        int length = thesaurusBuffer.langs.size();
        String idalpha = motcle.getIdalpha();
        for (int i = 0; i < length; ++i) {
            Lang lang = (Lang)thesaurusBuffer.langs.get(i);
            Label label = motcle.getLabels().getLabel(lang);
            if (label == null) continue;
            StringBuilder buffer = thesaurusBuffer.bufArray[i];
            PropertiesConversionZipEngine.dumpString(buffer, idalpha, true);
            buffer.append('=');
            PropertiesConversionZipEngine.dumpString(buffer, label.getLabelString(), false);
            buffer.append('\n');
        }
        Motcle next = ThesaurusUtils.getNext((Motcle)motcle);
        if (next != null) {
            PropertiesConversionZipEngine.bufMotcle(thesaurusBuffer, next);
        }
    }

    private static void dumpString(StringBuilder buffer, String string, boolean key) {
        int i = 0;
        if (!key && i < string.length() && string.charAt(i) == ' ') {
            buffer.append("\\ ");
            ++i;
        }
        while (i < string.length()) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if ("\\#!=:".indexOf(ch) >= 0 || key && ch == ' ') {
                        buffer.append('\\');
                    }
                    if (ch >= ' ' && ch <= '~') {
                        buffer.append(ch);
                        break;
                    }
                    String hex = Integer.toHexString(ch);
                    buffer.append("\\u");
                    for (int j = 0; j < 4 - hex.length(); ++j) {
                        buffer.append("0");
                    }
                    buffer.append(hex);
                }
            }
            ++i;
        }
    }

    private static class ThesaurusBuffer {
        private final Langs langs;
        private final StringBuilder[] bufArray;

        private ThesaurusBuffer(Langs langs, StringBuilder[] bufArray) {
            this.langs = langs;
            this.bufArray = bufArray;
        }
    }
}

