/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.resourcesupdate.tools.conversion;

import fr.exemole.bdfext.resourcesupdate.api.conversion.Conversion;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fichotheque.SubsetKey;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.localisation.Langs;

public class ConversionBuilder {
    private final String name;
    private final short mode;
    private final Map<SubsetKey, InternalThesaurusInfo> thesaurusMap = new LinkedHashMap<SubsetKey, InternalThesaurusInfo>();

    public ConversionBuilder(String name, short mode) {
        this.name = name;
        this.mode = mode;
    }

    public boolean addThesaurusInfo(Thesaurus thesaurus, String alias, boolean withUnderscorePrefix, Langs langs) {
        SubsetKey subsetKey = thesaurus.getSubsetKey();
        if (this.thesaurusMap.containsKey(subsetKey)) {
            return false;
        }
        if (!thesaurus.isIdalphaType()) {
            return false;
        }
        if (alias != null && (alias = alias.trim()).length() == 0) {
            alias = null;
        }
        this.thesaurusMap.put(subsetKey, new InternalThesaurusInfo(thesaurus, alias, withUnderscorePrefix, langs));
        return true;
    }

    public Conversion toConversion() {
        InternalThesaurusInfo[] thesaurusInfoArray = this.thesaurusMap.values().toArray(new InternalThesaurusInfo[this.thesaurusMap.size()]);
        return new InternalConversion(this.name, this.mode, thesaurusInfoArray);
    }

    private static class InternalThesaurusInfo
    implements Conversion.ThesaurusInfo {
        private final Thesaurus thesaurus;
        private final String alias;
        private final boolean withUnderscorePrefix;
        private final Langs langs;

        public InternalThesaurusInfo(Thesaurus thesaurus, String alias, boolean withUnderscorePrefix, Langs langs) {
            this.thesaurus = thesaurus;
            this.alias = alias;
            this.withUnderscorePrefix = withUnderscorePrefix;
            this.langs = langs;
        }

        @Override
        public Thesaurus getThesaurus() {
            return this.thesaurus;
        }

        @Override
        public String getAlias() {
            return this.alias;
        }

        @Override
        public boolean isWithUnderscorePrefix() {
            return this.withUnderscorePrefix;
        }

        @Override
        public Langs getLangs() {
            return this.langs;
        }
    }

    private static class InternalConversion
    implements Conversion {
        private final String name;
        private final short mode;
        private final InternalThesaurusInfo[] thesaurusInfoArray;

        private InternalConversion(String name, short mode, InternalThesaurusInfo[] thesaurusInfoArray) {
            this.name = name;
            this.mode = mode;
            this.thesaurusInfoArray = thesaurusInfoArray;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public short getMode() {
            return this.mode;
        }

        @Override
        public int getThesaurusInfoCount() {
            return this.thesaurusInfoArray.length;
        }

        @Override
        public Conversion.ThesaurusInfo getThesaurusInfo(int index) {
            return this.thesaurusInfoArray[index];
        }
    }
}

