/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.manuel.instructions;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.users.BdfUser;
import java.text.ParseException;
import java.util.List;
import net.fichotheque.ExistingIdException;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.ParentRecursivityException;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.CleanedString;

public class ThesaurusCommands {
    private static final Lang DEFAULT_LANG = Lang.build((String)"fr");
    BdfServer bdfServer;
    Fichotheque fichotheque;
    FichothequeEditor fichothequeEditor;
    Thesaurus chapitre;
    ThesaurusEditor chapitreEditor;

    public ThesaurusCommands(BdfServer bdfServer, BdfUser bdfUser) {
        this.bdfServer = bdfServer;
        this.fichotheque = bdfServer.getFichotheque();
        EditSession editSession = bdfServer.initEditSession(bdfUser, "ext:Utils/Manuel");
        this.fichothequeEditor = editSession.getFichothequeEditor();
        this.chapitre = FichothequeUtils.getThesaurus((Fichotheque)this.fichotheque, (String)"chapitre");
        this.chapitreEditor = this.fichothequeEditor.getThesaurusEditor(this.chapitre);
    }

    public void addNouveauChapitre(CleanedString lib) {
        String idalpha = ThesaurusCommands.getLettre(this.chapitre.getFirstLevelList().size());
        try {
            Motcle motcle = this.chapitreEditor.createMotcle(-1, idalpha);
            this.chapitreEditor.putLabel(motcle, DEFAULT_LANG, (CharSequence)lib);
        }
        catch (ExistingIdException eie) {
            throw new IllegalStateException(eie);
        }
        catch (ParseException pe) {
            throw new IllegalStateException(pe);
        }
    }

    public void changeLibelle(int id, CleanedString lib) {
        Motcle motcle = this.chapitre.getMotcleById(id);
        if (lib == null) {
            this.chapitreEditor.removeLabel(motcle, DEFAULT_LANG);
        } else {
            this.chapitreEditor.putLabel(motcle, DEFAULT_LANG, (CharSequence)lib);
        }
    }

    public void ajoutSouschapitre(int id, CleanedString lib) {
        if (lib == null) {
            return;
        }
        Motcle motcle = this.chapitre.getMotcleById(id);
        int num = motcle.getChildList().size() + 1;
        String idalpha = motcle.getIdalpha() + "." + num;
        try {
            Motcle motcle2 = this.chapitreEditor.createMotcle(-1, idalpha);
            this.chapitreEditor.putLabel(motcle2, DEFAULT_LANG, (CharSequence)lib);
            this.chapitreEditor.setParent(motcle2, motcle);
        }
        catch (ExistingIdException eie) {
            throw new IllegalStateException(eie);
        }
        catch (ParseException pe) {
            throw new IllegalStateException(pe);
        }
        catch (ParentRecursivityException pre) {
            throw new IllegalStateException(pre);
        }
        this.chapitreEditor.putLabel(motcle, DEFAULT_LANG, (CharSequence)lib);
    }

    public void changeChapitreOrder(String[] tokens) {
        int ln = tokens.length;
        if (ln == 0) {
            return;
        }
        List motcleList = this.chapitre.getFirstLevelList();
        this.setTempIdalpha(motcleList);
        int p = 0;
        for (int i = 0; i < ln; ++i) {
            String s = tokens[i];
            int idx = s.indexOf(61);
            if (idx == -1) continue;
            try {
                int motcleid = Integer.parseInt(s.substring(0, idx).trim());
                Motcle motcle = this.chapitre.getMotcleById(motcleid);
                if (motcle.getParent() != null) continue;
                try {
                    this.chapitreEditor.setIdalpha(motcle, ThesaurusCommands.getLettre(p));
                    ++p;
                    continue;
                }
                catch (ExistingIdException eie) {
                    throw new IllegalStateException(eie);
                }
                catch (ParseException pe) {
                    throw new IllegalStateException(pe);
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        ThesaurusUtils.sortByIdalpha((ThesaurusEditor)this.chapitreEditor, null, (boolean)false);
        List nvMotcleList = this.chapitre.getFirstLevelList();
        int i = 0;
        for (Motcle motcle : nvMotcleList) {
            String idalpha = motcle.getIdalpha();
            if (!idalpha.startsWith("zzzz_")) continue;
            try {
                this.chapitreEditor.setIdalpha(motcle, ThesaurusCommands.getLettre(i + p));
                ++i;
            }
            catch (ParseException | ExistingIdException e) {
                throw new IllegalStateException(e);
            }
        }
        for (Motcle motcle : nvMotcleList) {
            this.testSouschapitre(motcle, 1);
        }
    }

    public void changeSouschapitreOrder(int parentId, String[] tokens) {
        int ln = tokens.length;
        Motcle parent = this.chapitre.getMotcleById(parentId);
        String prefixe = parent.getIdalpha() + ".";
        if (parent == null) {
            return;
        }
        List motcleList = parent.getChildList();
        this.setTempIdalpha(motcleList);
        int p = 1;
        for (int i = 0; i < ln; ++i) {
            String s = tokens[i];
            int idx = s.indexOf(61);
            if (idx == -1) continue;
            try {
                int motcleid = Integer.parseInt(s.substring(0, idx).trim());
                Motcle motcle = this.chapitre.getMotcleById(motcleid);
                if (motcle.getParent() != parent) continue;
                try {
                    this.chapitreEditor.setIdalpha(motcle, prefixe + p);
                    ++p;
                    continue;
                }
                catch (ExistingIdException eie) {
                    throw new IllegalStateException(eie);
                }
                catch (ParseException pe) {
                    throw new IllegalStateException(pe);
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        ThesaurusUtils.sortByIdalpha((ThesaurusEditor)this.chapitreEditor, (Motcle)parent, (boolean)false);
        this.testSouschapitre(parent, p);
    }

    private void testSouschapitre(Motcle parent, int decalage) {
        String prefixe = parent.getIdalpha() + ".";
        for (Motcle motcle : parent.getChildList()) {
            String idalpha = motcle.getIdalpha();
            if (!idalpha.startsWith("zzzz_")) continue;
            try {
                this.chapitreEditor.setIdalpha(motcle, prefixe + decalage);
                ++decalage;
            }
            catch (ExistingIdException eie) {
                throw new IllegalStateException(eie);
            }
            catch (ParseException pe) {
                throw new IllegalStateException(pe);
            }
        }
    }

    public static void sort(ThesaurusEditor thesaurusEditor, Motcle parent) {
    }

    public static String getLettre(int index) {
        StringBuilder buf = new StringBuilder();
        buf.append((char)(index + 65));
        return buf.toString();
    }

    private void setTempIdalpha(List<Motcle> motcleList) {
        for (Motcle motcle : motcleList) {
            try {
                this.chapitreEditor.setIdalpha(motcle, "zzzz_" + motcle.getId());
            }
            catch (ParseException | ExistingIdException e) {
                throw new ShouldNotOccurException((Exception)e);
            }
            this.setTempIdalpha(motcle.getChildList());
        }
    }
}

