/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.wrapper;

import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasAttributes;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.event.AttributeEvent;
import net.desmodo.atlas.event.AttributeListener;
import net.desmodo.atlas.event.DescripteurEvent;
import net.desmodo.atlas.event.DescripteursListener;
import net.desmodo.atlas.event.LabelEvent;
import net.desmodo.atlas.event.LabelListener;
import net.desmodo.atlas.event.StructureEvent;
import net.desmodo.atlas.event.StructureListener;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.tools.ventilation.DefaultVentilationFactory;
import net.desmodo.atlas.ventilation.VentilationFactory;
import net.desmodo.atlas.wrapper.DisplayParameters;
import net.desmodo.atlas.wrapper.GroupeItemManager;
import net.desmodo.atlas.wrapper.GroupeItemManagerImpl;
import net.desmodo.atlas.wrapper.LibelleItemManager;
import net.desmodo.atlas.wrapper.LibelleItemManagerImpl;
import net.desmodo.atlas.wrapper.VentilationNameItemManager;
import net.desmodo.atlas.wrapper.VentilationNameItemManagerImpl;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.localisation.Lang;

public class AtlasWrapper {
    private final Atlas atlas;
    private final AtlasListener atlasListener;
    private final VentilationFactory ventilationFactory;
    private final GroupeItemManagerImpl groupeItemManager;
    private final LibelleItemManagerImpl libelleItemManager;
    private final VentilationNameItemManagerImpl ventilationNameManager;

    public AtlasWrapper(Atlas atlas, DisplayParameters displayParameters) {
        this.atlas = atlas;
        Lang lang = displayParameters.getLang();
        this.ventilationFactory = new DefaultVentilationFactory(null);
        this.groupeItemManager = new GroupeItemManagerImpl(atlas, lang);
        this.libelleItemManager = new LibelleItemManagerImpl(atlas, lang, this.groupeItemManager);
        this.ventilationNameManager = new VentilationNameItemManagerImpl(atlas, lang, this.groupeItemManager, this.ventilationFactory);
        this.atlasListener = new AtlasListener();
    }

    public Atlas getAtlas() {
        return this.atlas;
    }

    public GroupeItemManager getGroupeItemManager() {
        return this.groupeItemManager;
    }

    public LibelleItemManager getLibelleItemManager() {
        return this.libelleItemManager;
    }

    public VentilationNameItemManager getVentilationNameItemManager() {
        return this.ventilationNameManager;
    }

    public VentilationFactory getVentilationFactory() {
        return this.ventilationFactory;
    }

    private class AtlasListener
    implements DescripteursListener,
    StructureListener,
    LabelListener,
    AttributeListener {
        private AtlasListener() {
            AtlasWrapper.this.atlas.getStructure().addStructureListener(this);
            AtlasWrapper.this.atlas.getDescripteurs().addDescripteursListener(this);
            AtlasWrapper.this.atlas.addLibelleListener(this);
            AtlasWrapper.this.atlas.addAttributeListener(this);
        }

        @Override
        public void attributeRemoved(AttributeEvent attributeEvent) {
            AttributeKey attributeKey = attributeEvent.getAttributeKey();
            if (attributeKey.equals((Object)AtlasAttributes.COLOR_KEY)) {
                AtlasWrapper.this.groupeItemManager.colorChanged(attributeEvent.getAttributesHolder());
            }
        }

        @Override
        public void attributeChanged(AttributeEvent attributeEvent) {
            AttributeKey attributeKey = attributeEvent.getAttributeKey();
            if (attributeKey.equals((Object)AtlasAttributes.COLOR_KEY)) {
                AtlasWrapper.this.groupeItemManager.colorChanged(attributeEvent.getAttributesHolder());
            }
        }

        @Override
        public void contexteCreated(StructureEvent structureEvent) {
            Contexte contexte = structureEvent.getContexte();
            AtlasWrapper.this.libelleItemManager.createLibelleItem(contexte);
            AtlasWrapper.this.groupeItemManager.contexteCreated(contexte);
        }

        @Override
        public void grilleCreated(StructureEvent structureEvent) {
            Grille grille = structureEvent.getGrille();
            AtlasWrapper.this.groupeItemManager.grilleCreated(grille);
        }

        @Override
        public void familleChanged(DescripteurEvent descripteurEvent) {
            Descripteur descripteur = descripteurEvent.getDescripteur();
            Contexte newFamille = descripteur.getFamille();
            Contexte oldFamille = descripteurEvent.getOldFamille();
            AtlasWrapper.this.libelleItemManager.familleChanged(descripteur.getCode(), newFamille.getCode());
        }

        @Override
        public void labelRemoved(LabelEvent labelEvent) {
            Object labelHolder = labelEvent.getLabelHolder();
            if (labelHolder instanceof Descripteur) {
                AtlasWrapper.this.libelleItemManager.libelleChanged((Descripteur)labelHolder);
            } else if (labelHolder instanceof Contexte) {
                Contexte contexte = (Contexte)labelHolder;
                AtlasWrapper.this.groupeItemManager.libelleChanged(contexte);
                if (contexte.getTermType() == 3) {
                    AtlasWrapper.this.libelleItemManager.libelleChanged(contexte);
                }
            }
        }

        @Override
        public void labelChanged(LabelEvent labelEvent) {
            Object labelHolder = labelEvent.getLabelHolder();
            if (labelHolder instanceof Descripteur) {
                AtlasWrapper.this.libelleItemManager.libelleChanged((Descripteur)labelHolder);
            } else if (labelHolder instanceof Contexte) {
                Contexte contexte = (Contexte)labelHolder;
                AtlasWrapper.this.groupeItemManager.libelleChanged(contexte);
                if (contexte.getTermType() == 3) {
                    AtlasWrapper.this.libelleItemManager.libelleChanged(contexte);
                }
            } else if (labelHolder instanceof Grille) {
                AtlasWrapper.this.groupeItemManager.libelleChanged((Grille)labelHolder);
            }
        }

        @Override
        public void descripteurCreated(DescripteurEvent descripteurEvent) {
            Descripteur descripteur = descripteurEvent.getDescripteur();
            AtlasWrapper.this.libelleItemManager.createLibelleItem(descripteur);
        }

        @Override
        public void descripteurRemoved(DescripteurEvent descripteurEvent) {
            Descripteur descripteur = descripteurEvent.getDescripteur();
            AtlasWrapper.this.libelleItemManager.removeLibelleItem(descripteur.getCode());
        }

        @Override
        public void activeChanged(StructureEvent structureEvent) {
            Contexte contexte = structureEvent.getContexte();
            AtlasWrapper.this.groupeItemManager.activeChanged(contexte);
            AtlasWrapper.this.libelleItemManager.activeChanged(contexte);
        }

        @Override
        public void parentChanged(StructureEvent structureEvent) {
            Contexte contexte = structureEvent.getContexte();
            AtlasWrapper.this.groupeItemManager.parentChanged(contexte);
            AtlasWrapper.this.libelleItemManager.parentChanged(contexte);
        }

        @Override
        public void contexteRemoved(StructureEvent structureEvent) {
            Contexte contexte = structureEvent.getContexte();
            AtlasWrapper.this.groupeItemManager.contexteRemoved(contexte);
            AtlasWrapper.this.libelleItemManager.removeLibelleItem(contexte.getCode());
        }

        @Override
        public void grilleRemoved(StructureEvent structureEvent) {
            Grille grille = structureEvent.getGrille();
            AtlasWrapper.this.groupeItemManager.grilleRemoved(grille);
        }

        @Override
        public void childIndexChanged(StructureEvent structureEvent) {
            Contexte contexte = structureEvent.getContexte();
            AtlasWrapper.this.groupeItemManager.childIndexChanged(contexte);
            AtlasWrapper.this.libelleItemManager.indexChanged(contexte, contexte.getChildIndex());
        }
    }
}

