/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.liens;

import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.liens.LienExistantException;
import net.desmodo.atlas.liens.LienHierarchique;
import net.desmodo.atlas.liens.LienHierarchiqueGroup;
import net.desmodo.atlas.liens.LienHierarchiqueGroupList;
import net.desmodo.atlas.liens.LienHierarchiqueList;
import net.desmodo.atlas.liens.LienStructurel;
import net.desmodo.atlas.liens.LienStructurelList;
import net.desmodo.atlas.liens.LienSurLuiMemeException;
import net.desmodo.atlas.liens.LienSymetrique;
import net.desmodo.atlas.liens.LienSymetriqueList;
import net.desmodo.atlas.liens.Liens;
import net.desmodo.atlas.liens.LiensEditor;
import net.desmodo.atlas.liens.LiensFilter;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.InvalidContexteException;

public class LiensUtils {
    public static final Liens.LienLists EMPTY_LIENLISTS = new EmptyLienLists();
    public static final LiensFilter ACCEPT_ALL_LIENSFILTER = new AcceptAllLiensFilter();
    public static final LienStructurelList EMPTY_LIENSTRUCTUREL_LIST = new EmptyLienStructurelList();
    public static final LienSymetriqueList EMPTY_LIENSYMETRIQUE_LIST = new EmptyLienSymetriqueList();
    public static final LienHierarchiqueList EMPTY_LIENHIERARCHIQUE_LIST = new EmptyLienHierarchiqueList();
    public static final LienHierarchiqueGroupList EMPTY_LIENHIERARCHIQUEGROUP_LIST = new EmptyLienHierarchiqueGroupList();

    private LiensUtils() {
    }

    public static int getLienAsPereCount(Liens.LienLists lists) {
        return lists.getLienHierarchiqueGroupList().getLienHierarchiqueGroupCount() + lists.getLienSymetriqueList().getLienSymetriqueCount();
    }

    public static int getLienAsFilsCount(Liens.LienLists lists) {
        return lists.getLienHierarchiqueList().getLienHierarchiqueCount() + lists.getLienStructurelList().getLienStructurelCount();
    }

    public static LienHierarchique changeContexte(LiensEditor liensEditor, Descripteur descripteurPere, Descripteur descripteurFils, Contexte anciencontexte, Contexte nvcontexte, int index) throws LienExistantException, InvalidContexteException {
        boolean remove = liensEditor.removeLienHierarchique(descripteurPere, descripteurFils, anciencontexte);
        if (!remove) {
            return null;
        }
        try {
            LienHierarchique lh = liensEditor.createLienHierarchique(descripteurPere, descripteurFils, nvcontexte, index);
            return lh;
        }
        catch (LienSurLuiMemeException lienSurLuiMemeException) {
            return null;
        }
    }

    public static int indexOf(LienSymetrique lsm, Descripteur desc) {
        for (int i = 0; i < lsm.getDescripteurCount(); ++i) {
            if (!lsm.getDescripteur(i).equals(desc)) continue;
            return i;
        }
        return -1;
    }

    public static int getSensInverse(int index) {
        if (index == 0) {
            return 1;
        }
        if (index == 1) {
            return 0;
        }
        return -1;
    }

    public static Contexte getOtherContexte(LienStructurel lienStructurel, Contexte contexte) {
        if (contexte.equals(lienStructurel.getContexte1())) {
            return lienStructurel.getContexte2();
        }
        if (contexte.equals(lienStructurel.getContexte2())) {
            return lienStructurel.getContexte1();
        }
        return null;
    }

    public static boolean containsContexte(LienStructurel lic, Contexte contexte) {
        if (contexte.equals(lic.getContexte1())) {
            return true;
        }
        if (lic.isLienSurLuiMeme()) {
            return false;
        }
        return contexte.equals(lic.getContexte2());
    }

    public static LienStructurel getLienStructurel(Liens liens, Contexte contexte1, Contexte contexte2) {
        LienStructurelList lienList = liens.getLienStructurelList(contexte1);
        int lienCount = lienList.getLienStructurelCount();
        for (int i = 0; i < lienCount; ++i) {
            LienStructurel lienStructurel = lienList.getLienStructurel(i);
            if (!LiensUtils.containsContexte(lienStructurel, contexte2)) continue;
            return lienStructurel;
        }
        return null;
    }

    public static LienHierarchiqueGroup getLienHierarchiqueGroup(Liens liens, Descripteur descripteur, Contexte contexte) {
        Liens.LienLists lists = liens.getLienLists(descripteur);
        LienHierarchiqueGroupList groupList = lists.getLienHierarchiqueGroupList();
        int groupCount = groupList.getLienHierarchiqueGroupCount();
        for (int i = 0; i < groupCount; ++i) {
            LienHierarchiqueGroup lienHierarchiqueGroup = groupList.getLienHierarchiqueGroup(i);
            if (!lienHierarchiqueGroup.getContexte().equals(contexte)) continue;
            return lienHierarchiqueGroup;
        }
        return null;
    }

    public static LiensFilter getLiensFilter(String[] array) {
        return new InternalLiensFilter(array);
    }

    private static class InternalLiensFilter
    implements LiensFilter {
        private boolean lsm;
        private boolean lh_av;
        private boolean lh_am;
        private boolean lst;

        private InternalLiensFilter(String[] stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string.equals("lsm")) {
                    this.lsm = true;
                    continue;
                }
                if (string.equals("lh_av")) {
                    this.lh_av = true;
                    continue;
                }
                if (string.equals("lh_am")) {
                    this.lh_am = true;
                    continue;
                }
                if (!string.equals("lst")) continue;
                this.lst = true;
            }
        }

        @Override
        public boolean acceptLienSymetrique() {
            return this.lsm;
        }

        @Override
        public boolean acceptLienHierarchiqueAval() {
            return this.lh_av;
        }

        @Override
        public boolean acceptLienHierarchiqueAmont() {
            return this.lh_am;
        }

        @Override
        public boolean acceptLienStructurel() {
            return this.lst;
        }
    }

    static class EmptyLienLists
    implements Liens.LienLists {
        private EmptyLienLists() {
        }

        @Override
        public LienHierarchiqueList getLienHierarchiqueList() {
            return EMPTY_LIENHIERARCHIQUE_LIST;
        }

        @Override
        public LienStructurelList getLienStructurelList() {
            return EMPTY_LIENSTRUCTUREL_LIST;
        }

        @Override
        public LienSymetriqueList getLienSymetriqueList() {
            return EMPTY_LIENSYMETRIQUE_LIST;
        }

        @Override
        public LienHierarchiqueGroupList getLienHierarchiqueGroupList() {
            return EMPTY_LIENHIERARCHIQUEGROUP_LIST;
        }
    }

    private static class AcceptAllLiensFilter
    implements LiensFilter {
        private AcceptAllLiensFilter() {
        }

        @Override
        public boolean acceptLienSymetrique() {
            return true;
        }

        @Override
        public boolean acceptLienHierarchiqueAval() {
            return true;
        }

        @Override
        public boolean acceptLienHierarchiqueAmont() {
            return true;
        }

        @Override
        public boolean acceptLienStructurel() {
            return true;
        }
    }

    private static class EmptyLienStructurelList
    implements LienStructurelList {
        private EmptyLienStructurelList() {
        }

        @Override
        public int getLienStructurelCount() {
            return 0;
        }

        @Override
        public LienStructurel getLienStructurel(int i) {
            throw new IndexOutOfBoundsException();
        }
    }

    private static class EmptyLienSymetriqueList
    implements LienSymetriqueList {
        private EmptyLienSymetriqueList() {
        }

        @Override
        public int getLienSymetriqueCount() {
            return 0;
        }

        @Override
        public LienSymetrique getLienSymetrique(int i) {
            throw new IndexOutOfBoundsException();
        }
    }

    private static class EmptyLienHierarchiqueList
    implements LienHierarchiqueList {
        private EmptyLienHierarchiqueList() {
        }

        @Override
        public int getLienHierarchiqueCount() {
            return 0;
        }

        @Override
        public LienHierarchique getLienHierarchique(int i) {
            throw new IndexOutOfBoundsException();
        }
    }

    private static class EmptyLienHierarchiqueGroupList
    implements LienHierarchiqueGroupList {
        private EmptyLienHierarchiqueGroupList() {
        }

        @Override
        public int getLienHierarchiqueGroupCount() {
            return 0;
        }

        @Override
        public LienHierarchiqueGroup getLienHierarchiqueGroup(int i) {
            throw new IndexOutOfBoundsException();
        }
    }
}

