/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.overflow;

import java.awt.Dimension;
import java.awt.Rectangle;
import net.desmodo.atlas.display.overflow.Overflow;

public class DefaultOverflow
implements Overflow {
    private int north;
    private int west;
    private int east;
    private int south;
    private Dimension allowedSize;
    private Dimension realSize;
    boolean hasOverflow = false;

    public DefaultOverflow(Dimension allowedSize) {
        this.allowedSize = new Dimension(allowedSize);
        this.realSize = allowedSize;
    }

    @Override
    public int getNorthOverflow() {
        return this.north;
    }

    @Override
    public int getSouthOverflow() {
        return this.south;
    }

    @Override
    public int getWestOverflow() {
        return this.west;
    }

    @Override
    public int getEastOverflow() {
        return this.east;
    }

    @Override
    public Dimension getAllowedSize() {
        return new Dimension(this.allowedSize);
    }

    @Override
    public Dimension getRealSize() {
        return new Dimension(this.realSize);
    }

    @Override
    public boolean hasOverflow() {
        return this.hasOverflow;
    }

    protected void reinitAllowedSize(Dimension allowedSize) {
        this.allowedSize = new Dimension(allowedSize);
        this.realSize = allowedSize;
        this.hasOverflow = false;
        this.east = 0;
        this.west = 0;
        this.north = 0;
        this.south = 0;
    }

    protected void clearOverflow() {
        this.west = 0;
        this.east = 0;
        this.south = 0;
        this.north = 0;
        this.hasOverflow = false;
    }

    protected void checkOverflow(Rectangle rect) {
        if (rect == null) {
            this.hasOverflow = false;
            return;
        }
        int x = rect.x;
        int y = rect.y;
        this.north = Math.max(this.north, -y);
        this.west = Math.max(this.west, -x);
        this.east = Math.max(this.east, rect.width + x - this.allowedSize.width);
        this.south = Math.max(this.south, rect.height + y - this.allowedSize.height);
        this.realSize = new Dimension(this.allowedSize.width + this.west + this.east, this.allowedSize.height + this.north + this.south);
        this.hasOverflow = this.north > 0 || this.south > 0 || this.west > 0 || this.east > 0;
    }
}

