/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.thesaurus.Motcle;

public class Extract {
    private final Map<FicheMeta, Integer> relationMap = new HashMap<FicheMeta, Integer>();
    private final List<FicheMeta> relationList = new ArrayList<FicheMeta>();
    private final Map<Motcle, Integer> termMap = new HashMap<Motcle, Integer>();
    private final List<Motcle> termList = new ArrayList<Motcle>();
    private final Map<SubsetItem, Integer> resourceMap = new HashMap<SubsetItem, Integer>();
    private final List<SubsetItem> resourceList = new ArrayList<SubsetItem>();
    private final Map<SubsetItem, Map<IncludeKey, List<Integer>>> indexationMapOfMap = new HashMap<SubsetItem, Map<IncludeKey, List<Integer>>>();

    public Integer addRelation(FicheMeta relation) {
        Integer index = this.relationMap.get(relation);
        if (index != null) {
            return index;
        }
        index = this.relationList.size();
        this.relationMap.put(relation, index);
        this.relationList.add(relation);
        return index;
    }

    public Integer getRelationIndex(FicheMeta relation) {
        return this.relationMap.get(relation);
    }

    public Integer addTerm(Motcle term) {
        Integer index = this.termMap.get(term);
        if (index != null) {
            return index;
        }
        index = this.termList.size();
        this.termMap.put(term, index);
        this.termList.add(term);
        return index;
    }

    public Integer getTermIndex(Motcle term) {
        return this.termMap.get(term);
    }

    public Integer addResource(SubsetItem resource) {
        Integer index = this.resourceMap.get(resource);
        if (index != null) {
            return index;
        }
        index = this.resourceList.size();
        this.resourceMap.put(resource, index);
        this.resourceList.add(resource);
        return index;
    }

    public Integer getResourceIndex(SubsetItem resource) {
        return this.resourceMap.get(resource);
    }

    public void putIndexationMap(SubsetItem resource, Map<IncludeKey, List<Integer>> indexationMap) {
        this.indexationMapOfMap.put(resource, indexationMap);
    }

    public Map<IncludeKey, List<Integer>> getIndexationMap(SubsetItem resource) {
        return this.indexationMapOfMap.get(resource);
    }

    public Iterator<FicheMeta> getRelationIterator() {
        return this.relationList.iterator();
    }

    public Iterator<Motcle> getTermIterator() {
        return new TermIterator();
    }

    public Iterator<SubsetItem> getResourceIterator() {
        return this.resourceList.iterator();
    }

    private class TermIterator
    implements Iterator<Motcle> {
        private int cursor = 0;

        private TermIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor < Extract.this.termList.size();
        }

        @Override
        public Motcle next() {
            int current = this.cursor++;
            return (Motcle)Extract.this.termList.get(current);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

