/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.edition;

import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.edition.AtlasEditionBuilder;
import fr.exemole.bdfext.desmography.edition.HierarchyCreationBuilder;
import fr.exemole.bdfext.desmography.edition.TermBuilder;
import fr.exemole.bdfext.desmography.edition.TermChangeBuilder;
import fr.exemole.bdfext.desmography.edition.TermCreationBuilder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.attr.AttributeChangeBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelChangeBuilder;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class AtlasEditionDOMReader {
    private final MessageHandler messageHandler;
    private final AtlasEditionBuilder atlasEditionBuilder;
    private final Atlas atlas;

    public AtlasEditionDOMReader(AtlasEditionBuilder atlasEditionBuilder, Atlas atlas, MessageHandler messageHandler) {
        this.atlasEditionBuilder = atlasEditionBuilder;
        this.messageHandler = messageHandler;
        this.atlas = atlas;
    }

    public AtlasEditionDOMReader read(Element element) {
        String confirmationWord = element.getAttribute("confirmation-word");
        if (!confirmationWord.isEmpty()) {
            this.atlasEditionBuilder.setConfirmationWord(confirmationWord);
        }
        DOMUtils.readChildren((Element)element, (Consumer)new RootConsumer());
        return this;
    }

    private Motcle getTerm(Element element, String attributeName, String xpath) {
        String idString = element.getAttribute(attributeName);
        if (idString.length() == 0) {
            DomMessages.emptyAttribute((MessageHandler)this.messageHandler, (String)xpath, (String)attributeName);
            return null;
        }
        return this.getTerm(idString, attributeName, xpath);
    }

    private Motcle getTerm(String idString, String attributeName, String xpath) {
        try {
            int id = Integer.parseInt(idString);
            Motcle term = this.atlas.getTermThesaurus().getMotcleById(id);
            if (term == null) {
                DomMessages.wrongIntegerAttributeValue((MessageHandler)this.messageHandler, (String)xpath, (String)attributeName, (String)idString);
                return null;
            }
            return term;
        }
        catch (NumberFormatException nfe) {
            Motcle term = this.atlas.getTermThesaurus().getMotcleByIdalpha(idString);
            if (term == null) {
                DomMessages.wrongAttributeValue((MessageHandler)this.messageHandler, (String)xpath, (String)attributeName, (String)idString);
                return null;
            }
            return term;
        }
    }

    private List<Motcle> getTerms(Element element, String attributeName, String xpath) {
        String[] tokens;
        ArrayList<Motcle> result = new ArrayList<Motcle>();
        for (String token : tokens = StringUtils.getTechnicalTokens((String)element.getAttribute(attributeName), (boolean)true)) {
            Motcle term = this.getTerm(token, attributeName, xpath);
            if (term == null) continue;
            result.add(term);
        }
        return result;
    }

    private FicheMeta getRelation(Element element, String attributeName, String xpath) {
        int id;
        String idString = element.getAttribute(attributeName);
        if (idString.length() == 0) {
            DomMessages.emptyAttribute((MessageHandler)this.messageHandler, (String)xpath, (String)attributeName);
            return null;
        }
        try {
            id = Integer.parseInt(idString);
        }
        catch (NumberFormatException nfe) {
            DomMessages.wrongIntegerAttributeValue((MessageHandler)this.messageHandler, (String)xpath, (String)attributeName, (String)idString);
            return null;
        }
        FicheMeta relation = this.atlas.getRelationCorpus().getFicheMetaById(id);
        if (relation == null) {
            DomMessages.wrongIntegerAttributeValue((MessageHandler)this.messageHandler, (String)xpath, (String)attributeName, (String)idString);
        }
        return relation;
    }

    private boolean readTermElement(TermBuilder termBuilder, Element element) {
        String tagName = element.getTagName();
        if (tagName.equals("label")) {
            try {
                Label label = LabelUtils.readLabel((Element)element);
                if (label != null) {
                    LabelChangeBuilder changeLibelleHolderBuilder = termBuilder.getChangeLabelHolderBuilder();
                    changeLibelleHolderBuilder.putLabel(label);
                }
            }
            catch (ParseException e) {
                DomMessages.wrongLangAttribute((MessageHandler)this.messageHandler, (String)tagName, (String)element.getAttribute("xml:lang"));
            }
            return true;
        }
        if (tagName.equals("label-remove")) {
            try {
                Lang lang = Lang.parse((String)element.getAttribute("xml:lang"));
                LabelChangeBuilder changeLibelleHolderBuilder = termBuilder.getChangeLabelHolderBuilder();
                changeLibelleHolderBuilder.putRemovedLang(lang);
            }
            catch (ParseException e) {
                DomMessages.wrongLangAttribute((MessageHandler)this.messageHandler, (String)tagName, (String)element.getAttribute("xml:lang"));
            }
            return true;
        }
        if (tagName.equals("attr")) {
            AttributeKey attributeKey = AttributeUtils.readAttributeKey((Element)element, (MessageHandler)this.messageHandler, (String)tagName);
            if (attributeKey != null) {
                DOMUtils.readChildren((Element)element, (Consumer)new AttributeConsumer(attributeKey, termBuilder.getAttributeChangeBuilder()));
            }
            return true;
        }
        if (tagName.equals("attr-remove")) {
            AttributeKey attributeKey = AttributeUtils.readAttributeKey((Element)element, (MessageHandler)this.messageHandler, (String)tagName);
            if (attributeKey != null) {
                AttributeChangeBuilder attributeChangeBuilder = termBuilder.getAttributeChangeBuilder();
                attributeChangeBuilder.putRemovedAttributeKey(attributeKey);
            }
            return true;
        }
        return false;
    }

    public static AtlasEditionDOMReader init(AtlasEditionBuilder atlasEditionBuilder, Atlas atlas, MessageHandler messageHandler) {
        return new AtlasEditionDOMReader(atlasEditionBuilder, atlas, messageHandler);
    }

    private class RootConsumer
    implements Consumer<Element> {
        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("term-creation")) {
                TermCreationBuilder termCreationBuilder = new TermCreationBuilder();
                if (element.getAttribute("family-name").length() > 0) {
                    termCreationBuilder.setFamily(AtlasEditionDOMReader.this.getTerm(element, "family-name", tagName));
                }
                DOMUtils.readChildren((Element)element, (Consumer)new TermCreationConsumer(termCreationBuilder));
                AtlasEditionDOMReader.this.atlasEditionBuilder.add(termCreationBuilder.toTermCreation());
            } else if (tagName.equals("term-change")) {
                Motcle term = AtlasEditionDOMReader.this.getTerm(element, "name", tagName);
                if (term != null) {
                    TermChangeBuilder termChangeBuilder = new TermChangeBuilder(term);
                    DOMUtils.readChildren((Element)element, (Consumer)new TermChangeConsumer(termChangeBuilder));
                    AtlasEditionDOMReader.this.atlasEditionBuilder.add(termChangeBuilder.toTermChange());
                }
            } else if (tagName.equals("family-remove")) {
                Motcle family;
                Motcle term = AtlasEditionDOMReader.this.getTerm(element, "term-name", tagName);
                if (term != null && (family = AtlasEditionDOMReader.this.getTerm(element, "family-name", tagName)) != null) {
                    AtlasEditionDOMReader.this.atlasEditionBuilder.addFamilyRemove(term, family);
                }
            } else if (tagName.equals("family-add")) {
                Motcle family;
                Motcle term = AtlasEditionDOMReader.this.getTerm(element, "term-name", tagName);
                if (term != null && (family = AtlasEditionDOMReader.this.getTerm(element, "family-name", tagName)) != null) {
                    AtlasEditionDOMReader.this.atlasEditionBuilder.addFamilyAdd(term, family);
                }
            } else if (tagName.equals("inferiors-remove")) {
                FicheMeta relation = AtlasEditionDOMReader.this.getRelation(element, "relation-name", tagName);
                if (relation != null) {
                    ArrayList<Motcle> inferiors = new ArrayList<Motcle>();
                    DOMUtils.readChildren((Element)element, (Consumer)new InferiorsRemoveConsumer(inferiors, tagName));
                    if (!inferiors.isEmpty()) {
                        AtlasEditionDOMReader.this.atlasEditionBuilder.addInferiorsRemove(relation, inferiors);
                    }
                }
            } else if (tagName.equals("term-remove")) {
                Motcle term = AtlasEditionDOMReader.this.getTerm(element, "name", tagName);
                if (term != null) {
                    AtlasEditionDOMReader.this.atlasEditionBuilder.addTermRemove(term);
                }
            } else if (tagName.equals("term-merge")) {
                Motcle term = AtlasEditionDOMReader.this.getTerm(element, "name", tagName);
                Motcle destinationtTerm = AtlasEditionDOMReader.this.getTerm(element, "destination-name", tagName);
                if (term != null && destinationtTerm != null) {
                    AtlasEditionDOMReader.this.atlasEditionBuilder.addTermMerge(term, destinationtTerm);
                }
            } else if (tagName.equals("hierarchy-multiadd")) {
                List superiors = AtlasEditionDOMReader.this.getTerms(element, "superior-names", tagName);
                List inferiors = AtlasEditionDOMReader.this.getTerms(element, "inferior-names", tagName);
                if (!superiors.isEmpty() && !inferiors.isEmpty()) {
                    List sectors = AtlasEditionDOMReader.this.getTerms(element, "sector-names", tagName);
                    for (Motcle superior : superiors) {
                        for (Motcle inferior : inferiors) {
                            AtlasEditionDOMReader.this.atlasEditionBuilder.addHierachyAdd(superior, inferior, (Collection<Motcle>)sectors);
                        }
                    }
                }
            } else if (tagName.equals("hierarchy-uniqueadd")) {
                List superiors = AtlasEditionDOMReader.this.getTerms(element, "superior-names", tagName);
                List inferiors = AtlasEditionDOMReader.this.getTerms(element, "inferior-names", tagName);
                if (!superiors.isEmpty() && !inferiors.isEmpty()) {
                    List sectors = AtlasEditionDOMReader.this.getTerms(element, "sector-names", tagName);
                    AtlasEditionDOMReader.this.atlasEditionBuilder.addHierachyAdd(superiors, inferiors, (Collection<Motcle>)sectors);
                }
            } else if (tagName.equals("hierarchy-creation")) {
                String relationRole = element.getAttribute("relation-role");
                List others = AtlasEditionDOMReader.this.getTerms(element, "other-names", tagName);
                if (!others.isEmpty() && !relationRole.isEmpty()) {
                    HierarchyCreationBuilder hierarchyCreationBuilder = new HierarchyCreationBuilder(relationRole, others);
                    List sectors = AtlasEditionDOMReader.this.getTerms(element, "sector-names", tagName);
                    hierarchyCreationBuilder.setSectors(sectors);
                    if (element.getAttribute("family-name").length() > 0) {
                        hierarchyCreationBuilder.setFamily(AtlasEditionDOMReader.this.getTerm(element, "family-name", tagName));
                    }
                    DOMUtils.readChildren((Element)element, (Consumer)new HierarchyCreationConsumer(hierarchyCreationBuilder));
                    AtlasEditionDOMReader.this.atlasEditionBuilder.add(hierarchyCreationBuilder.toHierarchyCreation());
                }
            } else {
                DomMessages.unknownTagWarning((MessageHandler)AtlasEditionDOMReader.this.messageHandler, (String)tagName);
            }
        }
    }

    private class AttributeConsumer
    implements Consumer<Element> {
        private final AttributeKey attributeKey;
        private final AttributeChangeBuilder attributeChangeBuilder;

        public AttributeConsumer(AttributeKey attributeKey, AttributeChangeBuilder attributeChangeBuilder) {
            this.attributeKey = attributeKey;
            this.attributeChangeBuilder = attributeChangeBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("val")) {
                CleanedString cs = XMLUtils.toCleanedString((Element)element);
                if (cs != null) {
                    this.attributeChangeBuilder.appendValue(this.attributeKey, cs);
                } else {
                    DomMessages.emptyElement((MessageHandler)AtlasEditionDOMReader.this.messageHandler, (String)"val");
                }
            } else {
                DomMessages.unknownTagWarning((MessageHandler)AtlasEditionDOMReader.this.messageHandler, (String)tagName);
            }
        }
    }

    private class HierarchyCreationConsumer
    implements Consumer<Element> {
        private final HierarchyCreationBuilder hierarchyCreationBuilder;

        private HierarchyCreationConsumer(HierarchyCreationBuilder hierarchyCreationBuilder) {
            this.hierarchyCreationBuilder = hierarchyCreationBuilder;
        }

        @Override
        public void accept(Element element) {
            boolean done = AtlasEditionDOMReader.this.readTermElement(this.hierarchyCreationBuilder, element);
            if (!done) {
                String tagName = element.getTagName();
                DomMessages.unknownTagWarning((MessageHandler)AtlasEditionDOMReader.this.messageHandler, (String)tagName);
            }
        }
    }

    private class TermChangeConsumer
    implements Consumer<Element> {
        private final TermChangeBuilder termChangeBuilder;

        private TermChangeConsumer(TermChangeBuilder termChangeBuilder) {
            this.termChangeBuilder = termChangeBuilder;
        }

        @Override
        public void accept(Element element) {
            boolean done = AtlasEditionDOMReader.this.readTermElement(this.termChangeBuilder, element);
            if (!done) {
                String tagName = element.getTagName();
                DomMessages.unknownTagWarning((MessageHandler)AtlasEditionDOMReader.this.messageHandler, (String)tagName);
            }
        }
    }

    private class TermCreationConsumer
    implements Consumer<Element> {
        private final TermCreationBuilder termCreationBuilder;

        private TermCreationConsumer(TermCreationBuilder termCreationBuilder) {
            this.termCreationBuilder = termCreationBuilder;
        }

        @Override
        public void accept(Element element) {
            boolean done = AtlasEditionDOMReader.this.readTermElement(this.termCreationBuilder, element);
            if (!done) {
                String tagName = element.getTagName();
                DomMessages.unknownTagWarning((MessageHandler)AtlasEditionDOMReader.this.messageHandler, (String)tagName);
            }
        }
    }

    private class InferiorsRemoveConsumer
    implements Consumer<Element> {
        private final List<Motcle> inferiors;
        private final String xpath;

        private InferiorsRemoveConsumer(List<Motcle> inferiors, String xpath) {
            this.inferiors = inferiors;
            this.xpath = xpath;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("term")) {
                Motcle inferior = AtlasEditionDOMReader.this.getTerm(element, "name", this.xpath + "/term");
                if (inferior != null) {
                    this.inferiors.add(inferior);
                }
            } else {
                DomMessages.unknownTagWarning((MessageHandler)AtlasEditionDOMReader.this.messageHandler, (String)tagName);
            }
        }
    }
}

