/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.atlas;

import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasUtils;
import java.io.IOException;
import java.util.List;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.io.IOConsumer;

public final class AtlasIOLoops {
    private AtlasIOLoops() {
    }

    public static void forEachSubsector(Atlas atlas, Motcle term, IOConsumer<Motcle> subsectorConsumer) throws IOException {
        List<FicheMeta> subsectorRelationList = AtlasUtils.getRelationList(atlas, term, "superior", "subsectors");
        for (FicheMeta relation : subsectorRelationList) {
            List<Motcle> subsectorTermList = AtlasUtils.inferiors(atlas, relation);
            for (Motcle subsector : subsectorTermList) {
                subsectorConsumer.accept((Object)subsector);
            }
        }
    }

    public static void forEachSubfamily(Atlas atlas, Motcle family, IOConsumer<Motcle> subfamilyConsumer) throws IOException {
        List<FicheMeta> subfamilyRelationList = AtlasUtils.getRelationList(atlas, family, "superior", "subfamilies");
        for (FicheMeta relation : subfamilyRelationList) {
            List<Motcle> subfamilyTermList = AtlasUtils.inferiors(atlas, relation);
            for (Motcle subfamily : subfamilyTermList) {
                subfamilyConsumer.accept((Object)subfamily);
            }
        }
    }

    public static void forEachFamilyMember(Atlas atlas, Motcle family, IOConsumer<Motcle> memberConsumer) throws IOException {
        List<FicheMeta> memberRelationList = AtlasUtils.getRelationList(atlas, family, "superior", "family");
        for (FicheMeta relation : memberRelationList) {
            List<Motcle> memberTermList = AtlasUtils.inferiors(atlas, relation);
            for (Motcle member : memberTermList) {
                memberConsumer.accept((Object)member);
            }
        }
    }

    public static void forEachHierachyRelation(Atlas atlas, IOConsumer<FicheMeta> relationConsumer) throws IOException {
        for (FicheMeta ficheMeta : atlas.getRelationCorpus().getFicheMetaList()) {
            if (!AtlasUtils.getRelationType(ficheMeta).equals("hierarchy")) continue;
            relationConsumer.accept((Object)ficheMeta);
        }
    }
}

