/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.wrapper;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.desmodo.atlas.wrapper.LibelleItem;
import net.mapeadores.util.primitives.Range;
import net.mapeadores.util.text.collation.CollationUnit;

public final class LibelleItemComparator
implements Comparator<LibelleItem> {
    private static LibelleItemComparator libelleItemComparator = new LibelleItemComparator();
    private static SearchComparator searchComparator = new SearchComparator();

    private LibelleItemComparator() {
    }

    public static LibelleItemComparator getInstance() {
        return libelleItemComparator;
    }

    @Override
    public int compare(LibelleItem libItem1, LibelleItem libItem2) {
        int code2;
        int code1 = libItem1.getTermCode();
        if (code1 == (code2 = libItem2.getTermCode())) {
            return 0;
        }
        int result = libItem1.getCollatedString().getCollatedString().compareTo(libItem2.getCollatedString().getCollatedString());
        if (result != 0) {
            return result;
        }
        result = libItem1.toString().compareTo(libItem2.toString());
        if (result != 0) {
            return result;
        }
        if (code1 < code2) {
            return -1;
        }
        return 1;
    }

    public static int binarySearch(List<LibelleItem> list, CollationUnit collatedString) {
        int index = Collections.binarySearch(list, collatedString, searchComparator);
        if (index > 0) {
            int comp;
            int i = index - 1;
            while (i >= 0 && (comp = searchComparator.compare(list.get(i), collatedString)) == 0) {
                index = i--;
            }
        }
        return index;
    }

    public static Range startingWithStringRange(List<LibelleItem> list, CollationUnit collatedString) {
        String cs;
        int min = Collections.binarySearch(list, collatedString, searchComparator);
        if (min < 0 && (min = -min - 1) == list.size()) {
            return null;
        }
        int max = -1;
        String current = collatedString.getCollatedString();
        int i = min;
        while (i < list.size() && (cs = list.get(i).getCollatedString().getCollatedString()).startsWith(current)) {
            max = i++;
        }
        if (max < min) {
            return null;
        }
        return new Range(min, max);
    }

    static class SearchComparator
    implements Comparator<Object> {
        SearchComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof CollationUnit) {
                if (o2 instanceof LibelleItem) {
                    return this.compare((LibelleItem)o2, (CollationUnit)o1);
                }
                return 0;
            }
            if (o2 instanceof CollationUnit) {
                if (o1 instanceof LibelleItem) {
                    return this.compare((LibelleItem)o1, (CollationUnit)o2);
                }
                return 0;
            }
            return libelleItemComparator.compare((LibelleItem)o1, (LibelleItem)o2);
        }

        @Override
        int compare(LibelleItem libItem, CollationUnit colString) {
            int result = libItem.getCollatedString().getCollatedString().compareTo(colString.getCollatedString());
            if (result != 0) {
                return result;
            }
            return libItem.toString().compareTo(colString.getSourceString());
        }
    }
}

