/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.cef.htmlpages;

import fr.exemole.bdfext.cef.htmlpages.CefHtmlPrinter;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import net.fichotheque.Fichotheque;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.misc.ThesaurusMessageLocalisation;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.localisation.UserLangContext;

public abstract class CefHtmlPage
implements HtmlProducer {
    protected BdfServer bdfServer;
    protected BdfUser bdfUser;
    protected Lang workingLang;
    protected Fichotheque fichotheque;

    public CefHtmlPage(BdfParameters bdfParameters) {
        this(bdfParameters.getBdfServer(), bdfParameters.getBdfUser());
    }

    public CefHtmlPage(BdfServer bdfServer, BdfUser bdfUser) {
        this.bdfServer = bdfServer;
        this.bdfUser = bdfUser;
        this.fichotheque = bdfServer.getFichotheque();
        this.workingLang = bdfUser.getWorkingLang();
    }

    public void writeHtml(Appendable appendable) {
        Thesaurus thesaurus = FichothequeUtils.getThesaurus((Fichotheque)this.fichotheque, (String)"tableauloc");
        CefHtmlPrinter cefHtmlPrinter = this.getCefHtmlPrinter();
        cefHtmlPrinter.initPrinter(appendable);
        cefHtmlPrinter.addMessageLocalisation(this.bdfServer.getL10nManager().getMessageLocalisation((UserLangContext)this.bdfUser));
        cefHtmlPrinter.addMessageLocalisation((MessageLocalisation)new ThesaurusMessageLocalisation(thesaurus, this.workingLang, this.bdfServer.getThesaurusLangChecker(), this.bdfUser.getFormatLocale()));
        cefHtmlPrinter.addJsUrl("../../jquery/jquery.js").addJsUrl("http://www.exemole.fr/rsc-cef/js/cef.js").addCssUrl("http://www.exemole.fr/rsc-cef/css/cef.css");
        cefHtmlPrinter.printPage();
    }

    public Thesaurus getThesaurus(String subId) {
        return FichothequeUtils.getThesaurus((Fichotheque)this.fichotheque, (String)subId);
    }

    public Corpus getCorpus(String subId) {
        return FichothequeUtils.getCorpus((Fichotheque)this.fichotheque, (String)subId);
    }

    public abstract CefHtmlPrinter getCefHtmlPrinter();
}

