/*
 * Decompiled with CFR 0.152.
 */
package net.scrutari.dataexport.xml;

import java.io.IOException;
import net.scrutari.dataexport.api.ExportIOException;

public class XmlWriter {
    private final Appendable appendable;
    private final boolean signToBracketEscape;
    private int indentLength = 0;

    public XmlWriter(Appendable appendable, int indentLength, boolean includeXMLDeclaration, boolean signToBracketEscape) {
        this.appendable = appendable;
        this.indentLength = indentLength;
        this.signToBracketEscape = signToBracketEscape;
        if (includeXMLDeclaration) {
            this.appendXMLDeclaration();
        }
    }

    private void appendXMLDeclaration() {
        this.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    public void addEmptyElement(String name) {
        this.appendIndent();
        this.append('<');
        this.append(name);
        this.append("/>");
    }

    public void addEmptyElement(String name, String[] attributeNameArray, String[] attributeValueArray) {
        this.appendIndent();
        this.append('<');
        this.append(name);
        if (attributeNameArray != null) {
            for (int i = 0; i < attributeNameArray.length; ++i) {
                this.addAttribute(attributeNameArray[i], attributeValueArray[i]);
            }
        }
        this.append("/>");
    }

    public void openTag(String name) {
        this.appendIndent();
        this.append('<');
        this.append(name);
        this.append('>');
        this.increaseIndentValue();
    }

    public void openTagWithAttribute(String name, String attributeName, String attributeValue) {
        this.startOpenTag(name);
        this.addAttribute(attributeName, attributeValue);
        this.endOpenTag(true);
    }

    public void openTagWithAttributes(String name, String[] attributeNameArray, String[] attributeValueArray) {
        this.startOpenTag(name);
        for (int i = 0; i < attributeNameArray.length; ++i) {
            this.addAttribute(attributeNameArray[i], attributeValueArray[i]);
        }
        this.endOpenTag(true);
    }

    public void closeTag(String name) {
        this.closeTag(name, true);
    }

    public void append(char c) {
        try {
            this.appendable.append(c);
        }
        catch (IOException ioe) {
            throw new ExportIOException(ioe);
        }
    }

    public void append(CharSequence charSequence) {
        try {
            this.appendable.append(charSequence);
        }
        catch (IOException ioe) {
            throw new ExportIOException(ioe);
        }
    }

    public void escape(CharSequence charSequence) {
        if (charSequence == null) {
            return;
        }
        int length = charSequence.length();
        for (int i = 0; i < length; ++i) {
            char carac = charSequence.charAt(i);
            this.escape(carac);
        }
    }

    public void addSimpleElement(String tagname, String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        this.startOpenTag(tagname);
        this.endOpenTag(false);
        this.escape(value);
        this.closeTag(tagname, false);
    }

    public void addLibElement(String lang, String lib) {
        if (lang == null || lang.length() == 0) {
            lang = "und";
        }
        if (lang.equals("zxx")) {
            return;
        }
        this.startOpenTag("lib");
        this.addAttribute("xml:lang", lang);
        this.endOpenTag(false);
        this.escape(lib);
        this.closeTag("lib", false);
    }

    public void addLabelElement(String lang, String text) {
        if (lang == null || lang.length() == 0) {
            lang = "und";
        }
        if (lang.equals("zxx")) {
            return;
        }
        this.startOpenTag("label");
        this.addAttribute("xml:lang", lang);
        this.endOpenTag(false);
        this.escape(text);
        this.closeTag("label", false);
    }

    public void escape(char carac) {
        if (carac < ' ') {
            this.append(' ');
        } else {
            switch (carac) {
                case '&': {
                    this.append("&amp;");
                    break;
                }
                case '\"': {
                    this.append("&quot;");
                    break;
                }
                case '\'': {
                    this.append("&apos;");
                    break;
                }
                case '<': {
                    if (this.signToBracketEscape) {
                        this.append('\u2329');
                        break;
                    }
                    this.append("&lt;");
                    break;
                }
                case '>': {
                    if (this.signToBracketEscape) {
                        this.append('\u232a');
                        break;
                    }
                    this.append("&gt;");
                    break;
                }
                case '\u00a0': {
                    this.append("&#x00A0;");
                    break;
                }
                default: {
                    this.append(carac);
                }
            }
        }
    }

    private void startOpenTag(String name) {
        this.appendIndent();
        this.append('<');
        this.append(name);
    }

    private void endOpenTag(boolean increaseIndent) {
        this.append('>');
        if (increaseIndent) {
            this.increaseIndentValue();
        }
    }

    private void addAttribute(String attributeName, String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        this.append(' ');
        this.append(attributeName);
        this.append('=');
        this.append('\"');
        this.escape(value);
        this.append('\"');
    }

    private void closeTag(String name, boolean newLine) {
        if (newLine) {
            this.decreaseIndentValue();
            this.appendIndent();
        }
        this.append('<');
        this.append('/');
        this.append(name);
        this.append('>');
    }

    private void appendIndent() {
        if (this.indentLength > -1) {
            this.append('\n');
            for (int i = 0; i < this.indentLength; ++i) {
                this.append('\t');
            }
        }
    }

    private void increaseIndentValue() {
        ++this.indentLength;
    }

    private void decreaseIndentValue() {
        --this.indentLength;
    }
}

