/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.primitives.io.PrimitivesWriter;
import net.mapeadores.util.xml.XMLWriter;

public class PrimitivesXMLWriter
implements XMLWriter {
    public static final byte ELEMENT_START = 1;
    public static final byte ELEMENT_END = 2;
    public static final byte TEXT = 3;
    private PrimitivesWriter primitivesWriter;
    private AttributesBuffer attributesBuffer = new AttributesBuffer();

    public PrimitivesXMLWriter(PrimitivesWriter primitivesWriter) {
        this.primitivesWriter = primitivesWriter;
    }

    @Override
    public PrimitivesXMLWriter addText(CharSequence charSequence) throws IOException {
        this.text(charSequence);
        return this;
    }

    @Override
    public PrimitivesXMLWriter openTag(String name) throws IOException {
        this.elementStart(name);
        this.checkNoAttributes();
        return this;
    }

    @Override
    public PrimitivesXMLWriter openTag(String name, boolean indentBefore) throws IOException {
        this.elementStart(name);
        this.checkNoAttributes();
        return this;
    }

    @Override
    public PrimitivesXMLWriter startOpenTag(String name) throws IOException {
        this.elementStart(name);
        return this;
    }

    @Override
    public PrimitivesXMLWriter startOpenTag(String name, boolean indentBefore) throws IOException {
        this.elementStart(name);
        return this;
    }

    @Override
    public PrimitivesXMLWriter closeTag(String name) throws IOException {
        this.elementEnd();
        return this;
    }

    @Override
    public PrimitivesXMLWriter closeTag(String name, boolean indentBefore) throws IOException {
        this.elementEnd();
        return this;
    }

    @Override
    public PrimitivesXMLWriter endOpenTag() throws IOException {
        this.flushAttributes();
        return this;
    }

    @Override
    public PrimitivesXMLWriter addAttribute(String name, String value) throws IOException {
        if (value == null || value.length() == 0) {
            return this;
        }
        this.appendAttribute(name, value);
        return this;
    }

    @Override
    public PrimitivesXMLWriter addAttribute(String name, int value) throws IOException {
        this.appendAttribute(name, String.valueOf(value));
        return this;
    }

    @Override
    public PrimitivesXMLWriter closeEmptyTag() throws IOException {
        this.flushAttributes();
        this.elementEnd();
        return this;
    }

    @Override
    public PrimitivesXMLWriter addSimpleElement(String name, String value) throws IOException {
        if (value == null || value.length() == 0) {
            return this;
        }
        this.elementStart(name);
        this.checkNoAttributes();
        this.text(value);
        this.elementEnd();
        return this;
    }

    @Override
    public PrimitivesXMLWriter addEmptyElement(String name) throws IOException {
        this.elementStart(name);
        this.checkNoAttributes();
        this.elementEnd();
        return this;
    }

    @Override
    public PrimitivesXMLWriter addCData(CharSequence charSequence) throws IOException {
        this.text(charSequence);
        return this;
    }

    private void elementStart(String name) throws IOException {
        this.primitivesWriter.writeByte((byte)1);
        this.primitivesWriter.writeString(name);
    }

    private void checkNoAttributes() throws IOException {
        this.primitivesWriter.writeInt(0);
    }

    private void elementEnd() throws IOException {
        this.primitivesWriter.writeByte((byte)2);
    }

    private void text(CharSequence charSequence) throws IOException {
        int length = charSequence.length();
        if (length == 0) {
            return;
        }
        this.primitivesWriter.writeByte((byte)3);
        this.primitivesWriter.writeInt(length);
        for (int i = 0; i < length; ++i) {
            this.primitivesWriter.writeChar(charSequence.charAt(i));
        }
    }

    private void appendAttribute(String name, String value) throws IOException {
        this.attributesBuffer.append(name, value);
    }

    private void flushAttributes() throws IOException {
        this.attributesBuffer.flush(this.primitivesWriter);
    }

    private static class AttributesBuffer {
        private List<String> nameList = new ArrayList<String>();
        private List<String> valueList = new ArrayList<String>();

        private AttributesBuffer() {
        }

        private void flush(PrimitivesWriter primitivesWriter) throws IOException {
            int length = this.nameList.size();
            primitivesWriter.writeInt(length);
            for (int i = 0; i < length; ++i) {
                primitivesWriter.writeString(this.nameList.get(i));
                primitivesWriter.writeString(this.valueList.get(i));
            }
            this.nameList.clear();
            this.valueList.clear();
        }

        private void append(String name, String value) {
            this.nameList.add(name);
            this.valueList.add(value);
        }
    }
}

