/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import net.mapeadores.util.text.StringCleaner;

public class UriStringCleaner
implements StringCleaner {
    private static final Replacement apos = new Replacement("[\\u2018\\u2019]", "'");
    private static final Replacement dash = new Replacement("[_\\.,\\u00b7\\u2013]", "-");
    private static final Replacement left = new Replacement("[\\[{]", "(");
    private static final Replacement right = new Replacement("[\\]}]", ")");
    private static final Replacement word = new Replacement("[^-\\w()']", "_", 256);
    private static final Replacement multidash = new Replacement("[-]+", "-");
    private static final Replacement leftDash = new Replacement("[-][_]", "_");
    private static final Replacement rightDash = new Replacement("[_][-]", "_");
    private static final Replacement multiunderscore = new Replacement("[_]+", "_");
    private static final Replacement start = new Replacement("^[_]", "");
    private static final Replacement end = new Replacement("[_]$", "");
    private static final Replacement[] array = new Replacement[]{apos, dash, left, right, word, multidash, rightDash, leftDash, multiunderscore, start, end};
    private final boolean withEncoding;

    public UriStringCleaner(boolean withEncoding) {
        this.withEncoding = withEncoding;
    }

    @Override
    public String clean(String s) {
        for (Replacement replacement : array) {
            s = replacement.replace(s);
        }
        if (this.withEncoding) {
            try {
                URI uri = new URI(s);
                return uri.toASCIIString();
            }
            catch (URISyntaxException e) {
                return "uri-error";
            }
        }
        return s;
    }

    private static class Replacement {
        private final Pattern pattern;
        private final String replacement;

        private Replacement(String patternString, String replacement) {
            this.pattern = Pattern.compile(patternString);
            this.replacement = replacement;
        }

        private Replacement(String patternString, String replacement, int flag) {
            this.pattern = Pattern.compile(patternString, flag);
            this.replacement = replacement;
        }

        private String replace(String text) {
            String result = this.pattern.matcher(text).replaceAll(this.replacement);
            System.out.println(result);
            return result;
        }
    }
}

