/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.smtp;

import java.text.ParseException;
import java.util.List;
import java.util.Map;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.EmailCoreUtils;
import net.mapeadores.util.smtp.SmtpParameters;
import net.mapeadores.util.smtp.SmtpParametersBuilder;

public final class SmtpUtils {
    private SmtpUtils() {
    }

    public static SmtpParameters toSmtpParameters(Map<String, String> map, List<String> errorList) {
        String defaultFromString;
        String password;
        String username;
        SmtpParametersBuilder smtpParametersBuilder = new SmtpParametersBuilder();
        String authentificationType = map.get("authentification");
        if (authentificationType == null) {
            errorList.add("Missing key: authentification");
            authentificationType = "";
        } else {
            try {
                smtpParametersBuilder.setAuthentificationType(authentificationType);
            }
            catch (IllegalArgumentException iae) {
                errorList.add("Wrong value: authentification / " + authentificationType);
            }
        }
        smtpParametersBuilder.setPort(SmtpUtils.getDefaultPort(authentificationType));
        String host = map.get("host");
        if (host == null) {
            errorList.add("Missing key: host");
        } else {
            smtpParametersBuilder.setHost(host);
        }
        String portString = map.get("port");
        if (portString != null && (portString = portString.trim()).length() > 0) {
            try {
                int port = Integer.parseInt(portString);
                smtpParametersBuilder.setPort(port);
            }
            catch (NumberFormatException nfe) {
                errorList.add("Not integer value: port / " + portString);
            }
        }
        if ((username = map.get("username")) != null) {
            smtpParametersBuilder.setUsername(username);
        }
        if ((password = map.get("password")) != null) {
            smtpParametersBuilder.setPassword(password);
        }
        if ((defaultFromString = map.get("defaultfrom")) != null) {
            try {
                EmailCore defaultEmail = EmailCoreUtils.parse(defaultFromString);
                smtpParametersBuilder.addEmail("default.from", defaultEmail);
            }
            catch (ParseException pe) {
                errorList.add("Parse error: defaultfrom / " + pe.getMessage());
            }
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String name;
            String key = entry.getKey();
            if (!key.startsWith("email.") || (name = key.substring("email.".length())).isEmpty()) continue;
            try {
                EmailCore email = EmailCoreUtils.parse(entry.getValue());
                smtpParametersBuilder.addEmail(name, email);
            }
            catch (ParseException pe) {
                errorList.add("Parse error: " + key + " / " + pe.getMessage());
            }
        }
        SmtpParameters smtpParameters = smtpParametersBuilder.toSmtpParameters();
        if (SmtpUtils.isUserMandatory(authentificationType)) {
            if (smtpParameters.getUsername() == null) {
                errorList.add("Missing key: username");
            }
            if (smtpParameters.getPassword() == null) {
                errorList.add("Missing key: password");
            }
        }
        return smtpParameters;
    }

    public static boolean isUserMandatory(String authentificationType) {
        switch (authentificationType) {
            case "basic": 
            case "ssl": 
            case "starttls": {
                return true;
            }
        }
        return false;
    }

    public static int getDefaultPort(String authentificationType) {
        switch (authentificationType) {
            case "ssl": {
                return 465;
            }
            case "starttls": {
                return 587;
            }
        }
        return 25;
    }
}

