/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.security;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import net.mapeadores.util.base64.Base64;
import net.mapeadores.util.exceptions.NestedLibraryException;
import net.mapeadores.util.text.StringUtils;

public final class PasswordChecker {
    public static final String CLEAR = "clear";
    public static final String MD5 = "md5";
    public static final String PBKDF2 = "pbkdf2";
    private static final int iterations = 20000;
    private static final int saltLen = 32;
    private static final int desiredKeyLen = 256;

    private PasswordChecker() {
    }

    public static String getHash(String hashMode, String password) {
        if (password == null || password.length() == 0) {
            throw new IllegalArgumentException("Empty passwords are not supported.");
        }
        try {
            switch (hashMode) {
                case "clear": {
                    return "clear@" + password;
                }
                case "md5": {
                    return "md5@" + PasswordChecker.getMd5Hash(password);
                }
                case "pbkdf2": {
                    return "pbkdf2@" + PasswordChecker.getPbkdf2SaltedHash(password);
                }
            }
            throw new IllegalArgumentException("Unknown hashMode: " + hashMode);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new NestedLibraryException(e);
        }
    }

    private static String getMd5Hash(String password) {
        return StringUtils.toMD5(password);
    }

    private static String getPbkdf2SaltedHash(String password) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] salt = SecureRandom.getInstance("SHA1PRNG").generateSeed(32);
        return Base64.encodeBase64String(salt) + "$" + PasswordChecker.pbkdf2Hash(password, salt);
    }

    private static String pbkdf2Hash(String password, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory f = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        SecretKey key = f.generateSecret(new PBEKeySpec(password.toCharArray(), salt, 20000, 256));
        return Base64.encodeBase64String(key.getEncoded());
    }

    public static boolean check(String password, String stored) {
        String storedHash;
        String hashMode;
        if (password.length() == 0) {
            return false;
        }
        int idx = stored.indexOf(64);
        if (idx == -1) {
            hashMode = MD5;
            storedHash = stored;
        } else {
            hashMode = stored.substring(0, idx);
            storedHash = stored.substring(idx + 1);
        }
        try {
            switch (hashMode) {
                case "clear": {
                    return password.equals(storedHash);
                }
                case "md5": {
                    return PasswordChecker.checkMd5(password, storedHash);
                }
                case "pbkdf2": {
                    return PasswordChecker.checkPbkdf2(password, storedHash);
                }
            }
            return false;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new NestedLibraryException(e);
        }
    }

    public static String getHashMode(String stored) {
        int idx = stored.indexOf(64);
        if (idx == -1) {
            return MD5;
        }
        return stored.substring(0, idx);
    }

    private static boolean checkMd5(String password, String storedHash) {
        String md5Value = StringUtils.toMD5(password);
        return md5Value.equals(storedHash);
    }

    private static boolean checkPbkdf2(String password, String storedHash) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String[] saltAndPass = storedHash.split("\\$");
        if (saltAndPass.length != 2) {
            return false;
        }
        String hashOfInput = PasswordChecker.pbkdf2Hash(password, Base64.decodeBase64(saltAndPass[0]));
        return hashOfInput.equals(saltAndPass[1]);
    }
}

