/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.net;

import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;

public class UUIDURI {
    private String scheme;
    private String authorityUUID = null;
    private String internalName = null;
    private String[] idPartArray;

    public UUIDURI(String scheme, String authorityUUID, String internalName, String[] idPartArray) {
        if (scheme == null) {
            throw new IllegalArgumentException("scheme is null");
        }
        this.scheme = scheme;
        if (authorityUUID != null) {
            if (internalName == null) {
                throw new IllegalArgumentException("internalName is null when authorityUUID is not null");
            }
            this.internalName = internalName;
            this.authorityUUID = authorityUUID;
        }
        this.idPartArray = idPartArray == null ? new String[0] : idPartArray;
    }

    public UUIDURI(String scheme, String[] idPartArray) {
        this.scheme = scheme;
        this.idPartArray = idPartArray;
    }

    public boolean isAbsolute() {
        return this.authorityUUID != null;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getAuthorityUUID() {
        return this.authorityUUID;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String[] getIdPartArray() {
        return this.idPartArray;
    }

    public int getIdPartCount() {
        return this.idPartArray.length;
    }

    public String getIdPart(int i) {
        return this.idPartArray[i];
    }

    public String toString() {
        URIBuilder buf = new URIBuilder(this.scheme, this.authorityUUID, this.internalName);
        for (String idPart : this.idPartArray) {
            buf.appendIdPart(idPart);
        }
        return buf.toString();
    }

    public static UUIDURI parse(String s) throws ParseException {
        int idx = s.indexOf(58);
        if (idx == -1) {
            throw new ParseException("scheme is missing in " + s, s.length());
        }
        String scheme = s.substring(0, idx);
        String path = s.substring(idx + 1);
        if (path.length() == 0) {
            throw new ParseException("path is missing in " + s, s.length());
        }
        if (path.charAt(path.length() - 1) == '/') {
            throw new ParseException("path ends with / : " + s, s.length() - 1);
        }
        if (path.charAt(0) == '/') {
            return UUIDURI.parseAbsolute(scheme, path);
        }
        return UUIDURI.parseRelative(scheme, path);
    }

    public static String toString(String scheme, String idpart1) {
        URIBuilder buf = new URIBuilder(scheme, null, null);
        buf.appendIdPart(idpart1);
        return buf.toString();
    }

    public static String toString(String scheme, String idpart1, String idpart2) {
        URIBuilder buf = new URIBuilder(scheme, null, null);
        buf.appendIdPart(idpart1);
        buf.appendIdPart(idpart2);
        return buf.toString();
    }

    public static String toString(String scheme, String idpart1, String idpart2, String idpart3) {
        URIBuilder buf = new URIBuilder(scheme, null, null);
        buf.appendIdPart(idpart1);
        buf.appendIdPart(idpart2);
        buf.appendIdPart(idpart3);
        return buf.toString();
    }

    private static UUIDURI parseAbsolute(String scheme, String path) throws ParseException {
        String internalName;
        String[] tokens = path.split("/");
        if (tokens.length < 2) {
            throw new ParseException("absolute must have an minimum of two parts " + path, path.length() - 1);
        }
        String authorityUUID = tokens[1];
        try {
            internalName = URLDecoder.decode(tokens[2], "UTF-8");
        }
        catch (IOException ieo) {
            throw new ParseException("ioe exception occurs", 0);
        }
        int length = tokens.length;
        String[] idPartArray = new String[length - 2];
        for (int i = 0; i < length - 2; ++i) {
            try {
                idPartArray[i] = URLDecoder.decode(tokens[i + 2], "UTF-8");
                continue;
            }
            catch (IOException ieo) {
                throw new ParseException("ioe exception occurs", 0);
            }
        }
        return new UUIDURI(scheme, authorityUUID, internalName, idPartArray);
    }

    private static UUIDURI parseRelative(String scheme, String path) throws ParseException {
        String[] tokens = path.split("/");
        int length = tokens.length;
        String[] idPartArray = new String[length];
        for (int i = 0; i < length; ++i) {
            try {
                idPartArray[i] = URLDecoder.decode(tokens[i], "UTF-8");
                continue;
            }
            catch (IOException ieo) {
                throw new ParseException("ioe exception occurs", 0);
            }
        }
        return new UUIDURI(scheme, idPartArray);
    }

    private static class URIBuilder {
        private StringBuilder buf = new StringBuilder();
        private boolean relativePart = true;

        private URIBuilder(String scheme, String authorityUUID, String internalName) {
            this.buf.append(scheme);
            this.buf.append(':');
            if (authorityUUID != null) {
                this.buf.append('/');
                this.buf.append(authorityUUID);
                this.buf.append('/');
                try {
                    this.buf.append(URLEncoder.encode(internalName, "UTF-8"));
                }
                catch (IOException ioe) {
                    throw new IllegalStateException("should not occur", ioe);
                }
                this.relativePart = false;
            }
        }

        public String toString() {
            return this.buf.toString();
        }

        private void appendIdPart(String idpart) {
            if (this.relativePart) {
                this.relativePart = false;
            } else {
                this.buf.append('/');
            }
            try {
                this.buf.append(URLEncoder.encode(idpart, "UTF-8"));
            }
            catch (IOException ioe) {
                throw new IllegalStateException("should not occur", ioe);
            }
        }
    }
}

