/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.html.jsoup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.mapeadores.util.exceptions.ResponseCodeException;
import net.mapeadores.util.exceptions.ResponseContentTypeException;
import net.mapeadores.util.html.MetaReport;
import net.mapeadores.util.json.JSONArray;
import net.mapeadores.util.json.JSONObject;
import net.mapeadores.util.text.MultiStringable;
import net.mapeadores.util.text.StringUtils;
import org.jsoup.HttpStatusException;
import org.jsoup.Jsoup;
import org.jsoup.UnsupportedMimeTypeException;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class MetaReportEngine {
    private final Map<String, ProtocolValuesBuilder> builderMap = new HashMap<String, ProtocolValuesBuilder>();

    private MetaReportEngine() {
    }

    private MetaReport scan(Document doc) {
        Object content;
        String name;
        this.addHtml("title", doc.title());
        this.addHtml("lang", doc.firstElementChild().attr("lang"));
        Element head = doc.head();
        for (Element meta : head.select("meta[name]")) {
            name = meta.attr("name");
            content = meta.attr("content");
            if (((String)content).isEmpty()) continue;
            if (name.startsWith("DC.")) {
                this.addDublinCore(name.substring(3), (String)content);
                continue;
            }
            this.addHtml(name, (String)content);
        }
        for (Element meta : head.select("meta[property]")) {
            String namespace;
            int idx;
            name = meta.attr("property");
            content = meta.attr("content");
            if (((String)content).isEmpty() || (idx = name.indexOf(58)) <= 1 || !MetaReportEngine.isOpenGraphNameSpace(namespace = name.substring(0, idx))) continue;
            this.addOpenGraph(name, (String)content);
        }
        for (Element script : head.select("script[type='application/ld+json']")) {
            StringBuilder buf = new StringBuilder();
            for (DataNode datanode : script.dataNodes()) {
                buf.append(datanode.getWholeData());
            }
            try {
                JSONObject ldJson = new JSONObject(buf.toString());
                this.addJsonLd(ldJson);
            }
            catch (IOException iOException) {}
        }
        TreeMap<String, MetaReport.ProtocolValues> protocolMap = new TreeMap<String, MetaReport.ProtocolValues>();
        for (ProtocolValuesBuilder builder : this.builderMap.values()) {
            protocolMap.put(builder.getName(), builder.toProtocolValues());
        }
        return new InternalMetaReport(protocolMap);
    }

    private void addHtml(String name, String value) {
        ProtocolValuesBuilder builder = this.getProtocoleValuesBuilder("Html");
        if (name.equals("keywords")) {
            String[] tokens;
            for (String token : tokens = StringUtils.getTokens(value, ',', (short)2)) {
                builder.add(name, token);
            }
        } else {
            builder.add(name, value);
        }
    }

    private void addDublinCore(String name, String value) {
        ProtocolValuesBuilder builder = this.getProtocoleValuesBuilder("DublinCore");
        builder.add(name, value);
    }

    private void addOpenGraph(String name, String value) {
        ProtocolValuesBuilder builder = this.getProtocoleValuesBuilder("OpenGraph");
        builder.add(name, value);
    }

    private void addJsonLd(JSONObject ldJson) {
        ProtocolValuesBuilder builder = this.getProtocoleValuesBuilder("Schema");
        Iterator it = ldJson.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = ldJson.get(key);
            if (value instanceof String) {
                builder.add(key, (String)value);
                continue;
            }
            if (value instanceof JSONArray) {
                JSONArray array = (JSONArray)value;
                int length = array.length();
                for (int i = 0; i < length; ++i) {
                    Object item = array.get(i);
                    if (item instanceof String) {
                        builder.add(key, (String)item);
                        continue;
                    }
                    if (item instanceof JSONObject) {
                        JSONObject itemObj = (JSONObject)item;
                        if (itemObj.has("name")) {
                            builder.add(key, itemObj.getString("name"));
                            continue;
                        }
                        builder.add(key, itemObj.toString());
                        continue;
                    }
                    builder.add(key, item.toString());
                }
                continue;
            }
            builder.add(key, value.toString());
        }
    }

    private ProtocolValuesBuilder getProtocoleValuesBuilder(String name) {
        ProtocolValuesBuilder builder = this.builderMap.get(name);
        if (builder == null) {
            builder = new ProtocolValuesBuilder(name);
            this.builderMap.put(name, builder);
        }
        return builder;
    }

    public static MetaReport run(String url) throws IOException, ResponseCodeException, ResponseContentTypeException {
        try {
            Document doc = Jsoup.connect((String)url).userAgent("Mozilla/5.0 (X11; Linux x86_64; rv:91.0) Gecko/20100101 Firefox/91.0").get();
            return MetaReportEngine.run(doc);
        }
        catch (HttpStatusException hse) {
            throw new ResponseCodeException(hse.getStatusCode());
        }
        catch (UnsupportedMimeTypeException umte) {
            throw new ResponseContentTypeException(umte.getMimeType());
        }
    }

    public static MetaReport run(Document doc) {
        MetaReportEngine engine = new MetaReportEngine();
        return engine.scan(doc);
    }

    private static boolean isOpenGraphNameSpace(String namespace) {
        switch (namespace) {
            case "og": 
            case "article": 
            case "book": 
            case "video": 
            case "music": {
                return true;
            }
        }
        return false;
    }

    private static class ProtocolValuesBuilder {
        private final String name;
        Map<String, List<String>> listMap = new LinkedHashMap<String, List<String>>();

        private ProtocolValuesBuilder(String name) {
            this.name = name;
        }

        private String getName() {
            return this.name;
        }

        private void add(String name, String value) {
            if (!value.isEmpty()) {
                List<String> stringList = this.listMap.get(name);
                if (stringList == null) {
                    stringList = new ArrayList<String>();
                    this.listMap.put(name, stringList);
                }
                stringList.add(value);
            }
        }

        private MetaReport.ProtocolValues toProtocolValues() {
            LinkedHashMap<String, MultiStringable> finalMap = new LinkedHashMap<String, MultiStringable>();
            for (Map.Entry<String, List<String>> entry : this.listMap.entrySet()) {
                finalMap.put(entry.getKey(), StringUtils.toMultiStringable((Collection<String>)entry.getValue()));
            }
            return new InternalProtocolValues(this.name, finalMap);
        }
    }

    private static class InternalMetaReport
    implements MetaReport {
        private final Map<String, MetaReport.ProtocolValues> protocolMap;

        private InternalMetaReport(Map<String, MetaReport.ProtocolValues> protocolMap) {
            this.protocolMap = protocolMap;
        }

        @Override
        public Set<String> getAvalaibleProtocolSet() {
            return Collections.unmodifiableSet(this.protocolMap.keySet());
        }

        @Override
        public MetaReport.ProtocolValues getProtocolValues(String protocolName) {
            return this.protocolMap.get(protocolName);
        }
    }

    private static class InternalProtocolValues
    implements MetaReport.ProtocolValues {
        private final String protocolName;
        private final Map<String, MultiStringable> valueMap;

        private InternalProtocolValues(String protocolName, Map<String, MultiStringable> valueMap) {
            this.protocolName = protocolName;
            this.valueMap = valueMap;
        }

        @Override
        public String getProtocolName() {
            return this.protocolName;
        }

        @Override
        public Set<String> getParamNameSet() {
            return Collections.unmodifiableSet(this.valueMap.keySet());
        }

        @Override
        public MultiStringable getValues(String name) {
            return this.valueMap.get(name);
        }
    }
}

