/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.exceptions;

import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ExceptionsUtils {
    private ExceptionsUtils() {
    }

    public static void append(StringBuilder buf, String publicId, String systemId, int lineNumber, int columnNumber) {
        if (publicId != null) {
            buf.append(publicId);
            buf.append(":");
        }
        if (systemId != null) {
            buf.append(systemId);
            buf.append(":");
        }
        buf.append("line#");
        buf.append(lineNumber);
        buf.append(":col#");
        buf.append(columnNumber);
        buf.append(": ");
    }

    public static void append(StringBuilder buf, SAXParseException spe) {
        ExceptionsUtils.append(buf, spe.getPublicId(), spe.getSystemId(), spe.getLineNumber(), spe.getColumnNumber());
    }

    public static String getMessage(Exception e) {
        String message = e.getClass().getName();
        String msg = e.getLocalizedMessage();
        if (msg != null) {
            message = message + " : " + msg;
        }
        return message;
    }

    public static String getSAXExceptionMessage(SAXException saxException) {
        if (saxException instanceof SAXParseException) {
            StringBuilder buf = new StringBuilder();
            ExceptionsUtils.append(buf, (SAXParseException)saxException);
            buf.append(saxException.getLocalizedMessage());
            return buf.toString();
        }
        return ExceptionsUtils.getMessage(saxException);
    }
}

