/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.css.parse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.mapeadores.opendocument.css.parse.CssSource;

public class FileCssSource
implements CssSource {
    private final File file;
    private final File directoryFile;

    public FileCssSource(File file) {
        this.file = file;
        this.directoryFile = file.getParentFile();
    }

    @Override
    public Reader getReader() throws IOException {
        FileInputStream inputStream = new FileInputStream(this.file);
        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
        return reader;
    }

    @Override
    public CssSource getImportCssSource(String url) {
        File newFile = this.getFile(url);
        if (!newFile.exists()) {
            return null;
        }
        return new FileCssSource(newFile);
    }

    public File getFile(String url) {
        return new File(this.directoryFile, url);
    }

    @Override
    public String getCssSourceURI() {
        return this.file.toURI().toString();
    }
}

