/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.css.extraction;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class CssExtraction {
    private OutputStream cssOutputStream;
    private OutputStream xmlOutputStream;
    private ZipInputStream zipInputStream;

    public CssExtraction(InputStream inputStream) {
        this.zipInputStream = new ZipInputStream(inputStream);
    }

    public void setCssOutputStream(OutputStream cssOutputStream) {
        this.cssOutputStream = cssOutputStream;
    }

    public void setXmlOutputStream(OutputStream xmlOutputStream) {
        this.xmlOutputStream = xmlOutputStream;
    }

    public static void extract(File odFile, File cssFile) throws IOException, TransformerException {
        CssExtraction.extract(odFile, cssFile, null);
    }

    public static void extract(File odFile, File cssFile, File xmlFile) throws IOException, TransformerException {
        FileInputStream inputStream = new FileInputStream(odFile);
        BufferedOutputStream cssOutputStream = null;
        if (cssFile != null) {
            cssOutputStream = new BufferedOutputStream(new FileOutputStream(cssFile));
        }
        BufferedOutputStream xmlOutputStream = null;
        if (xmlFile != null) {
            xmlOutputStream = new BufferedOutputStream(new FileOutputStream(xmlFile));
        }
        CssExtraction.extract(inputStream, cssOutputStream, xmlOutputStream);
        ((InputStream)inputStream).close();
        if (xmlOutputStream != null) {
            ((OutputStream)xmlOutputStream).close();
        }
        if (cssOutputStream != null) {
            ((OutputStream)cssOutputStream).close();
        }
    }

    public static void extract(InputStream inputStream, OutputStream cssOutputStream, OutputStream xmlOutputStream) throws IOException, TransformerException {
        CssExtraction cssExtraction = new CssExtraction(inputStream);
        cssExtraction.setCssOutputStream(cssOutputStream);
        cssExtraction.setXmlOutputStream(xmlOutputStream);
        cssExtraction.extract();
    }

    public void extract() throws IOException, TransformerException {
        ZipEntry zipEntry = null;
        while ((zipEntry = this.zipInputStream.getNextEntry()) != null) {
            String name = zipEntry.getName();
            if (!name.equals("styles.xml")) continue;
            byte[] content = CssExtraction.getByteArray(this.zipInputStream);
            if (this.cssOutputStream != null) {
                Transformer transformer = CssExtraction.getTransformer();
                StreamSource source = new StreamSource(new ByteArrayInputStream(content));
                StreamResult result = new StreamResult(this.cssOutputStream);
                transformer.transform(source, result);
            }
            if (this.xmlOutputStream == null) break;
            this.xmlOutputStream.write(content);
            break;
        }
    }

    private static byte[] getByteArray(ZipInputStream zipInputStream) throws IOException {
        int length = 1024;
        byte[] buffer = new byte[length];
        int p = 0;
        ByteArrayOutputStream beaos = new ByteArrayOutputStream();
        while ((p = zipInputStream.read(buffer)) != -1) {
            beaos.write(buffer, 0, p);
        }
        return beaos.toByteArray();
    }

    private static Transformer getTransformer() throws IOException {
        StreamSource streamSource = new StreamSource(CssExtraction.class.getResourceAsStream("styles.xsl"));
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer transformer = factory.newTransformer(streamSource);
            return transformer;
        }
        catch (TransformerConfigurationException tce) {
            throw new IllegalStateException(tce);
        }
    }
}

