/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.importation;

import java.io.IOException;
import java.util.List;
import net.fichotheque.importation.LiensImport;
import net.fichotheque.include.IncludeKey;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class LiensImportXMLPart
extends XMLPart {
    public LiensImportXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void addLiensImport(LiensImport liensImport) throws IOException {
        List<LiensImport.LienImport> list;
        List<LiensImport.LienImport> replaceList;
        boolean withLiage = liensImport.isLiageRemoved();
        List<IncludeKey> removedIncludeKeyList = liensImport.getRemovedIncludeKeyList();
        if (!removedIncludeKeyList.isEmpty() || withLiage) {
            this.startOpenTag("liens");
            this.addAttribute("type", "remove");
            this.endOpenTag();
            for (IncludeKey includeKey : removedIncludeKeyList) {
                this.addSimpleElement("include-key", includeKey.getKeyString());
            }
            if (withLiage) {
                this.addSimpleElement("include-key", "liage");
            }
            this.closeTag("liens");
        }
        if (!(replaceList = liensImport.getReplaceLienImportList()).isEmpty()) {
            this.startOpenTag("liens");
            this.addAttribute("type", "replace");
            this.endOpenTag();
            for (LiensImport.LienImport lienImport : replaceList) {
                this.addLienImport(lienImport);
            }
            this.closeTag("liens");
        }
        if (!(list = liensImport.getAppendLienImportList()).isEmpty()) {
            this.startOpenTag("liens");
            this.addAttribute("type", "append");
            this.endOpenTag();
            for (LiensImport.LienImport lienImport : list) {
                this.addLienImport(lienImport);
            }
            this.closeTag("liens");
        }
    }

    private void addLienImport(LiensImport.LienImport lienImport) throws IOException {
        this.startOpenTag("lien");
        IncludeKey includeKey = lienImport.getOriginIncludeKey();
        if (includeKey != null) {
            this.addAttribute("include-key", includeKey.getKeyString());
        } else {
            this.addAttribute("subset", lienImport.getOtherSubset().getSubsetKeyString());
        }
        this.addAttribute("poids", lienImport.getWeight());
        LiensImport.Other other = lienImport.getOther();
        if (other instanceof LiensImport.IdOther) {
            this.addAttribute("id", ((LiensImport.IdOther)other).getOtherId());
        } else if (other instanceof LiensImport.LabelOther) {
            Label label = ((LiensImport.LabelOther)other).getLabel();
            this.addAttribute("lang", label.getLang().toString());
            this.addAttribute("label", label.getLabelString());
        } else if (other instanceof LiensImport.IdalphaOther) {
            this.addAttribute("idalpha", ((LiensImport.IdalphaOther)other).getIdalpha());
        }
        this.closeEmptyTag();
    }
}

