/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.selection;

import net.fichotheque.corpus.fiche.DateItem;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.NumberItem;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.selection.FieldTest;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.utils.PointeurUtils;
import net.mapeadores.util.conditions.ConditionsUtils;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.conditions.TextTestEngine;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.primitives.DateFilter;
import net.mapeadores.util.primitives.DateFilterUtils;
import net.mapeadores.util.primitives.Ranges;

public class FieldTestFactory {
    public static final FieldTest FALSE_FIELDTEST = new ConstantFieldTest(false);
    public static final FieldTest TRUE_FIELDTEST = new ConstantFieldTest(true);

    private FieldTestFactory() {
    }

    public static FieldTest newFieldTest(TextCondition fieldCondition, SelectionContext selectionContext, FieldKey[] fieldKeyArray) {
        short conditionType = ConditionsUtils.getConditionType(fieldCondition);
        switch (conditionType) {
            case 2: {
                return FALSE_FIELDTEST;
            }
            case 0: 
            case 1: {
                return TRUE_FIELDTEST;
            }
            case 4: {
                return new EmptyFieldTest(false, fieldKeyArray);
            }
            case 3: {
                return new EmptyFieldTest(true, fieldKeyArray);
            }
            case 5: 
            case 6: {
                return new ContentFieldTest(fieldCondition, selectionContext, fieldKeyArray);
            }
        }
        throw new SwitchException("state = " + conditionType);
    }

    public static FieldTest newDateFieldTest(DateFilter dateIntegerFilter, FieldKey[] fieldKeyArray) {
        return new DateIntegerFilterFieldTest(dateIntegerFilter, fieldKeyArray);
    }

    public static FieldTest newEmptyFieldTest(boolean isEmpty, FieldKey[] fieldKeyArray) {
        return new EmptyFieldTest(isEmpty, fieldKeyArray);
    }

    public static FieldTest newRangesFieldTest(Ranges ranges, FieldKey[] fieldKeyArray) {
        return new RangeListFieldTest(ranges, fieldKeyArray);
    }

    private static class EmptyFieldTest
    implements FieldTest {
        private final FieldKey[] fieldKeyArray;
        private final boolean isEmpty;

        private EmptyFieldTest(boolean isEmpty, FieldKey[] fieldKeyArray) {
            this.fieldKeyArray = fieldKeyArray;
            this.isEmpty = isEmpty;
        }

        @Override
        public boolean success(FichePointeur fichePointeur) {
            for (FieldKey fieldKey : this.fieldKeyArray) {
                Object obj = fichePointeur.getValue(fieldKey);
                if (obj == null) continue;
                return !this.isEmpty;
            }
            return this.isEmpty;
        }
    }

    private static class ContentFieldTest
    implements FieldTest {
        private final SelectionContext selectionContext;
        private final FieldKey[] fieldKeyArray;
        private final TextTestEngine textTestEngine;

        private ContentFieldTest(TextCondition contentCondition, SelectionContext selectionContext, FieldKey[] fieldKeyArray) {
            this.selectionContext = selectionContext;
            this.fieldKeyArray = fieldKeyArray;
            this.textTestEngine = TextTestEngine.newInstance(contentCondition, selectionContext.getWorkingLang());
        }

        @Override
        public boolean success(FichePointeur fichePointeur) {
            this.textTestEngine.start();
            for (FieldKey fieldKey : this.fieldKeyArray) {
                Object obj = fichePointeur.getValue(fieldKey);
                if (obj == null) {
                    obj = "";
                }
                PointeurUtils.testContent(this.selectionContext, this.textTestEngine, obj);
                if (this.textTestEngine.canStop()) break;
            }
            return this.textTestEngine.getResult();
        }
    }

    private static class DateIntegerFilterFieldTest
    implements FieldTest {
        private final FieldKey[] fieldKeyArray;
        private final DateFilter dateFilter;

        private DateIntegerFilterFieldTest(DateFilter dateFilter, FieldKey[] fieldKeyArray) {
            this.dateFilter = dateFilter;
            this.fieldKeyArray = fieldKeyArray;
        }

        @Override
        public boolean success(FichePointeur fichePointeur) {
            for (FieldKey fieldKey : this.fieldKeyArray) {
                Object obj = fichePointeur.getValue(fieldKey);
                if (obj == null) continue;
                if (obj instanceof DateItem) {
                    if (!this.dateFilter.containsDate(((DateItem)obj).getDate())) continue;
                    return true;
                }
                if (!(obj instanceof FicheItems)) continue;
                FicheItems ficheItems = (FicheItems)obj;
                int size = ficheItems.size();
                Object obj1 = ficheItems.get(0);
                if (!(obj1 instanceof DateItem)) continue;
                DateItem startDateItem = (DateItem)obj1;
                if (size == 1) {
                    if (!DateFilterUtils.intersects(startDateItem.getDate(), this.dateFilter)) continue;
                    return true;
                }
                Object obj2 = ficheItems.get(1);
                if (!(obj2 instanceof DateItem)) continue;
                DateItem endDateItem = (DateItem)obj2;
                if (!DateFilterUtils.intersects(startDateItem.getDate(), endDateItem.getDate(), this.dateFilter)) continue;
                return true;
            }
            return false;
        }
    }

    private static class RangeListFieldTest
    implements FieldTest {
        private final FieldKey[] fieldKeyArray;
        private final Ranges ranges;

        private RangeListFieldTest(Ranges ranges, FieldKey[] fieldKeyArray) {
            this.ranges = ranges;
            this.fieldKeyArray = fieldKeyArray;
        }

        @Override
        public boolean success(FichePointeur fichePointeur) {
            for (FieldKey fieldKey : this.fieldKeyArray) {
                Object obj = fichePointeur.getValue(fieldKey);
                if (obj == null) continue;
                if (obj instanceof NumberItem) {
                    int intg = (int)((NumberItem)obj).getDecimal().getPartieEntiere();
                    if (!this.ranges.contains(intg)) continue;
                    return true;
                }
                if (!(obj instanceof FicheItems)) continue;
                FicheItems ficheItems = (FicheItems)obj;
                int size = ficheItems.size();
                for (int j = 0; j < size; ++j) {
                    int intg;
                    FicheItem ficheItem = (FicheItem)ficheItems.get(j);
                    if (!(ficheItem instanceof NumberItem) || !this.ranges.contains(intg = (int)((NumberItem)ficheItem).getDecimal().getPartieEntiere())) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class ConstantFieldTest
    implements FieldTest {
        private final boolean constantAnswer;

        private ConstantFieldTest(boolean constantAnswer) {
            this.constantAnswer = constantAnswer;
        }

        @Override
        public boolean success(FichePointeur fichePointeur) {
            return this.constantAnswer;
        }
    }
}

