/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.selection;

import net.fichotheque.addenda.Document;
import net.fichotheque.selection.CroisementCondition;
import net.fichotheque.selection.DocumentQuery;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.utils.selection.FilteredCroisementBuilder;
import net.mapeadores.util.conditions.ConditionsUtils;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.conditions.TextTestEngine;
import net.mapeadores.util.exceptions.SwitchException;

class DocumentSelectEngine {
    private final CroisementCondition croisementCondition;
    private final short conditionType;
    private final TextTestEngine textTestEngine;

    DocumentSelectEngine(DocumentQuery documentQuery, CroisementCondition croisementCondition, SelectionContext selectionContext) {
        this.croisementCondition = croisementCondition;
        TextCondition nameCondition = documentQuery.getNameCondition();
        if (nameCondition != null) {
            this.conditionType = ConditionsUtils.getConditionType(nameCondition);
            this.textTestEngine = ConditionsUtils.isPartialState(this.conditionType) ? TextTestEngine.newInstance(nameCondition, selectionContext.getWorkingLang()) : null;
        } else {
            this.conditionType = 0;
            this.textTestEngine = null;
        }
    }

    void filter(Document document, FilteredCroisementBuilder builder) {
        if (!this.isSelected(document)) {
            return;
        }
        builder.testCondition(this.croisementCondition);
    }

    boolean isSelected(Document document) {
        return this.conditionType == 0 || this.isNameSelected(document);
    }

    private boolean isNameSelected(Document document) {
        switch (this.conditionType) {
            case 2: {
                return false;
            }
            case 0: 
            case 1: {
                return true;
            }
            case 4: {
                return true;
            }
            case 3: {
                return false;
            }
            case 5: 
            case 6: {
                return this.textTestEngine.isSelected(document.getBasename());
            }
        }
        throw new SwitchException("state = " + this.conditionType);
    }
}

