/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.thesaurus;

import java.text.ParseException;
import java.util.List;
import net.fichotheque.ExistingIdException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.ParentRecursivityException;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadata;
import net.fichotheque.tools.FichothequeTools;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.exceptions.ImplementationException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.text.Label;

public final class ThesaurusTools {
    private ThesaurusTools() {
    }

    public static void transferChildren(FichothequeEditor fichothequeEditor, Motcle source, Motcle destination) throws ParentRecursivityException {
        List<Motcle> childList = source.getChildList();
        if (childList.isEmpty()) {
            return;
        }
        Thesaurus thesaurus = source.getThesaurus();
        if (destination != null) {
            if (!destination.getThesaurus().equals(thesaurus)) {
                throw new IllegalArgumentException("source and destination are not coming from the same thesaurus");
            }
            if (ThesaurusUtils.isDescendant(destination, source)) {
                throw new ParentRecursivityException(destination, source);
            }
        }
        ThesaurusEditor thesaurusEditor = fichothequeEditor.getThesaurusEditor(thesaurus);
        for (Motcle child : childList) {
            try {
                thesaurusEditor.setParent(child, destination);
            }
            catch (ParentRecursivityException pre) {
                throw new ImplementationException("recursivity has been checked before in the script", pre);
            }
        }
    }

    public static void transferLabels(FichothequeEditor fichothequeEditor, Motcle source, Motcle destination, Langs langs) {
        if (langs == null) {
            return;
        }
        Thesaurus thesaurus = destination.getThesaurus();
        if (thesaurus.isBabelienType()) {
            return;
        }
        ThesaurusEditor thesaurusEditor = fichothequeEditor.getThesaurusEditor(thesaurus);
        ThesaurusMetadata metadata = thesaurus.getThesaurusMetadata();
        int langSize = langs.size();
        for (Label label : source.getLabels()) {
            Label current;
            Lang lang = label.getLang();
            boolean accepte = false;
            for (int i = 0; i < langSize; ++i) {
                if (!((Lang)langs.get(i)).equals(lang)) continue;
                accepte = true;
                break;
            }
            if (!accepte || (current = destination.getLabels().getLabel(lang)) != null) continue;
            thesaurusEditor.putLabel(destination, label);
        }
    }

    public static void merge(FichothequeEditor fichothequeEditor, Motcle source, Motcle destination, Langs langs) throws ParentRecursivityException {
        if (source.getThesaurus().equals(destination.getThesaurus())) {
            ThesaurusTools.transferChildren(fichothequeEditor, source, destination);
        } else {
            try {
                ThesaurusTools.transferChildren(fichothequeEditor, source, source.getParent());
            }
            catch (ParentRecursivityException pre) {
                throw new ImplementationException("recursivity has been checked before in the script", pre);
            }
        }
        FichothequeTools.transferCroisements(fichothequeEditor, source, destination);
        if (langs != null) {
            ThesaurusTools.transferLabels(fichothequeEditor, source, destination, langs);
        }
        fichothequeEditor.getThesaurusEditor(source.getSubsetKey()).removeMotcle(source);
    }

    public static Motcle move(FichothequeEditor fichothequeEditor, Motcle source, Thesaurus destination, Langs langs) {
        if (source.getThesaurus().equals(destination)) {
            throw new IllegalArgumentException("source.getThesaurus().equals(destination)");
        }
        ThesaurusEditor destinationEditor = fichothequeEditor.getThesaurusEditor(destination.getSubsetKey());
        Motcle copy = ThesaurusTools.copy(fichothequeEditor, destinationEditor, source);
        try {
            ThesaurusTools.merge(fichothequeEditor, source, copy, langs);
        }
        catch (ParentRecursivityException pre) {
            throw new ImplementationException("recursivity has been checked before in the script", pre);
        }
        return copy;
    }

    public static Motcle copy(FichothequeEditor fichothequeEditor, ThesaurusEditor thesaurusEditor, Motcle source) {
        String idalpha = source.getIdalpha();
        Thesaurus destinationThesaurus = thesaurusEditor.getThesaurus();
        if (destinationThesaurus.isIdalphaType()) {
            if (idalpha != null && destinationThesaurus.getMotcleByIdalpha(idalpha) != null) {
                idalpha = null;
            }
            if (idalpha == null && destinationThesaurus.getMotcleByIdalpha(idalpha = "n_" + String.valueOf(source.getId())) != null) {
                int p = 1;
                while (true) {
                    String test;
                    if (destinationThesaurus.getMotcleByIdalpha(test = idalpha + "-" + p) == null) {
                        idalpha = test;
                        break;
                    }
                    ++p;
                }
            }
        } else {
            idalpha = null;
        }
        try {
            Motcle destination = thesaurusEditor.createMotcle(-1, idalpha);
            ThesaurusTools.copy(thesaurusEditor, source, destination);
            return destination;
        }
        catch (ParseException | ExistingIdException e) {
            throw new ShouldNotOccurException(e);
        }
    }

    public static void copy(ThesaurusEditor thesaurusEditor, Motcle origin, Motcle destination) {
        for (Label label : origin.getLabels()) {
            thesaurusEditor.putLabel(destination, label);
        }
        FichothequeEditor fichothequeEditor = thesaurusEditor.getFichothequeEditor();
        for (Attribute attribute : origin.getAttributes()) {
            fichothequeEditor.putAttribute(destination, attribute);
        }
    }
}

