/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.selection;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.FichothequeQueries;
import net.fichotheque.selection.MotcleQuery;
import net.fichotheque.utils.SelectionUtils;

public class FichothequeQueriesBuilder {
    private final List<FicheQuery> ficheQueryList = new ArrayList<FicheQuery>();
    private final List<MotcleQuery> motcleQueryList = new ArrayList<MotcleQuery>();

    public FichothequeQueriesBuilder addFichothequeQueries(FichothequeQueries fichothequeQueries) {
        for (FicheQuery ficheQuery : fichothequeQueries.getFicheQueryList()) {
            this.addFicheQuery(ficheQuery);
        }
        for (MotcleQuery motcleQuery : fichothequeQueries.getMotcleQueryList()) {
            this.addMotcleQuery(motcleQuery);
        }
        return this;
    }

    public FichothequeQueriesBuilder addFicheQuery(FicheQuery ficheQuery) {
        if (!ficheQuery.isEmpty()) {
            this.ficheQueryList.add(ficheQuery);
        }
        return this;
    }

    public FichothequeQueriesBuilder addMotcleQuery(MotcleQuery motcleQuery) {
        if (!motcleQuery.isEmpty()) {
            this.motcleQueryList.add(motcleQuery);
        }
        return this;
    }

    public FichothequeQueries toFichothequeQueries() {
        List<FicheQuery> immutableFicheQueryList = SelectionUtils.wrap(this.ficheQueryList.toArray(new FicheQuery[this.ficheQueryList.size()]));
        List<MotcleQuery> immutableMotcleQueryList = SelectionUtils.wrap(this.motcleQueryList.toArray(new MotcleQuery[this.motcleQueryList.size()]));
        return new InternalFichothequeQueries(immutableFicheQueryList, immutableMotcleQueryList);
    }

    public static FichothequeQueriesBuilder init() {
        return new FichothequeQueriesBuilder();
    }

    private static class InternalFichothequeQueries
    implements FichothequeQueries {
        private final List<FicheQuery> ficheQueryList;
        private final List<MotcleQuery> motcleQueryList;

        private InternalFichothequeQueries(List<FicheQuery> ficheQueryList, List<MotcleQuery> motcleQueryList) {
            this.ficheQueryList = ficheQueryList;
            this.motcleQueryList = motcleQueryList;
        }

        @Override
        public List<FicheQuery> getFicheQueryList() {
            return this.ficheQueryList;
        }

        @Override
        public List<MotcleQuery> getMotcleQueryList() {
            return this.motcleQueryList;
        }
    }
}

