/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers.handlers;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.parsers.LiensParser;
import net.fichotheque.tools.importation.parsers.Row;
import net.mapeadores.util.text.StringUtils;

public class CroisementHandlers {
    private final boolean replaceDefault;
    private final boolean allowLiage;
    private final List<InternalCroisementHandler> list = new ArrayList<InternalCroisementHandler>();
    private final Map<IncludeKey, InternalCroisementHandler> map = new HashMap<IncludeKey, InternalCroisementHandler>();
    private InternalCroisementHandler liageCroisementHandler;

    public CroisementHandlers(boolean replaceDefault, boolean allowLiage) {
        this.replaceDefault = replaceDefault;
        this.allowLiage = allowLiage;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void handle(Row row, LiensParser liensParser) {
        for (InternalCroisementHandler croisementHandler : this.list) {
            croisementHandler.handle(row, liensParser);
        }
    }

    public boolean testCroisementHandlerCandidate(Fichotheque fichotheque, String field, int index, ParseResultBuilder parseResultBuilder) {
        InternalCroisementHandler croisementHandler;
        int idx = field.indexOf("!");
        boolean replace = this.replaceDefault;
        boolean idalpha = false;
        if (idx > 0) {
            String[] tokens;
            String params = field.substring(idx + 1);
            field = field.substring(0, idx);
            String[] stringArray = tokens = StringUtils.getTokens(params, ',', (short)2);
            int n = stringArray.length;
            block12: for (int i = 0; i < n; ++i) {
                String token;
                switch (token = stringArray[i]) {
                    case "append": {
                        replace = false;
                        continue block12;
                    }
                    case "replace": {
                        replace = true;
                        continue block12;
                    }
                    case "idalpha": {
                        idalpha = true;
                    }
                }
            }
        }
        try {
            IncludeKey includeKey = IncludeKey.parse(field);
            SubsetKey subsetKey = includeKey.getSubsetKey();
            Subset subset = fichotheque.getSubset(subsetKey);
            if (subset == null) {
                parseResultBuilder.unknownSubset(includeKey.getKeyString());
                return true;
            }
            croisementHandler = this.getOrCreate(includeKey);
        }
        catch (ParseException pe) {
            if (field.equals("liage")) {
                if (!this.allowLiage) {
                    parseResultBuilder.notAvailableColumn(field);
                    return true;
                }
                if (this.liageCroisementHandler == null) {
                    this.liageCroisementHandler = new InternalCroisementHandler(null);
                    this.list.add(this.liageCroisementHandler);
                }
                croisementHandler = this.liageCroisementHandler;
            }
            return false;
        }
        if (replace) {
            croisementHandler.setReplace(true);
        }
        if (idalpha) {
            croisementHandler.setIdalpha(true);
        }
        croisementHandler.addIndex(index);
        return true;
    }

    private InternalCroisementHandler getOrCreate(IncludeKey includeKey) {
        InternalCroisementHandler croisementHandler = this.map.get(includeKey);
        if (croisementHandler == null) {
            croisementHandler = new InternalCroisementHandler(includeKey);
            this.list.add(croisementHandler);
            this.map.put(includeKey, croisementHandler);
        }
        return croisementHandler;
    }

    private static class InternalCroisementHandler {
        private final IncludeKey includeKey;
        private final List<Integer> indexList = new ArrayList<Integer>();
        private boolean replace = false;
        private boolean idalpha = false;

        private InternalCroisementHandler(IncludeKey includeKey) {
            this.includeKey = includeKey;
        }

        private void setReplace(boolean replace) {
            this.replace = replace;
        }

        private void setIdalpha(boolean idalpha) {
            this.idalpha = idalpha;
        }

        private void handle(Row row, LiensParser liensParser) {
            if (this.replace) {
                if (this.includeKey == null) {
                    liensParser.checkReplaceLiage();
                } else {
                    liensParser.checkReplaceIncludeKey(this.includeKey);
                }
            }
            int columnCount = row.getColumnCount();
            if (this.indexList.size() == 1) {
                int index = this.indexList.get(0);
                if (index < columnCount) {
                    if (this.includeKey == null) {
                        liensParser.addLiage(row.getColumnValue(index), this.replace);
                    } else {
                        liensParser.add(this.includeKey, row.getColumnValue(index), this.replace, this.idalpha);
                    }
                }
            } else {
                ArrayList<String> stringList = new ArrayList<String>();
                for (Integer index : this.indexList) {
                    if (index >= columnCount) continue;
                    stringList.add(row.getColumnValue(index));
                }
                if (this.includeKey == null) {
                    liensParser.addLiage(stringList, this.replace);
                } else {
                    liensParser.add(this.includeKey, stringList, this.replace, this.idalpha);
                }
            }
        }

        private void addIndex(int index) {
            this.indexList.add(index);
        }
    }
}

