/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers;

import java.text.ParseException;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.thesaurus.metadata.ThesaurusLangChecker;
import net.fichotheque.thesaurus.policies.PolicyProvider;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.corpus.EditCorpusImportBuilder;
import net.fichotheque.tools.importation.corpus.EditFicheImportBuilder;
import net.fichotheque.tools.importation.parsers.CorpusColumns;
import net.fichotheque.tools.importation.parsers.CorpusRowParser;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.importation.parsers.handlers.HandlerUtils;
import net.fichotheque.tools.parsers.FicheParser;
import net.mapeadores.util.primitives.FuzzyDate;

public class CorpusCreationRowParser
extends CorpusRowParser {
    private final EditCorpusImportBuilder editCorpusImportBuilder;
    private final ParseResultBuilder parseResultBuilder;
    private final FicheParser.Parameters ficheParserParameters;
    private final CorpusColumns corpusColumns;
    private final PolicyProvider policyProvider;
    private final ThesaurusLangChecker thesaurusLangChecker;
    private final FicheItems defaultOwners;

    CorpusCreationRowParser(EditCorpusImportBuilder editCorpusImportBuilder, ParseResultBuilder parseResultBuilder, FicheParser.Parameters ficheParserParameters, CorpusColumns corpusColumns, PolicyProvider policyProvider, ThesaurusLangChecker thesaurusLangChecker, FicheItems defaultOwners) {
        this.editCorpusImportBuilder = editCorpusImportBuilder;
        this.parseResultBuilder = parseResultBuilder;
        this.ficheParserParameters = ficheParserParameters;
        this.corpusColumns = corpusColumns;
        this.policyProvider = policyProvider;
        this.thesaurusLangChecker = thesaurusLangChecker;
        this.defaultOwners = defaultOwners;
    }

    @Override
    public EditCorpusImportBuilder getCorpusImportBuilder() {
        return this.editCorpusImportBuilder;
    }

    @Override
    public void parseRow(int rowNumber, Row row) {
        int creationDateIndex;
        int idIndex = this.corpusColumns.getIdIndex();
        int columnCount = row.getColumnCount();
        Corpus corpus = this.editCorpusImportBuilder.getCorpus();
        int newId = -1;
        if (idIndex != -1 && columnCount > idIndex) {
            String id = row.getColumnValue(idIndex).trim();
            try {
                newId = Integer.parseInt(id);
                FicheMeta ficheMeta = corpus.getFicheMetaById(newId);
                if (ficheMeta != null) {
                    this.parseResultBuilder.existingId(rowNumber, id);
                    return;
                }
            }
            catch (NumberFormatException nfe) {
                this.parseResultBuilder.notIntegerId(rowNumber, id);
                return;
            }
        }
        EditFicheImportBuilder ficheImportBuilder = this.editCorpusImportBuilder.getEditFicheImportBuilder(newId);
        if (this.corpusColumns.hasFicheHandler()) {
            HandlerUtils.populate(ficheImportBuilder.getFicheChangeBuilder(), this.corpusColumns.getFicheHandlerArray(), row, corpus, this.ficheParserParameters);
        }
        if (this.corpusColumns.hasAttributeHandler()) {
            HandlerUtils.populate(ficheImportBuilder.getAttributeChangeBuilder(), this.corpusColumns.getAttributeHandlerArray(), row);
        }
        if (this.corpusColumns.hasCroisementHandler()) {
            HandlerUtils.populate(ficheImportBuilder.getLiensImportBuilder(), this.corpusColumns.getCroisementHandlers(), row, corpus, this.ficheParserParameters.getWorkingLang(), this.policyProvider, this.thesaurusLangChecker);
        }
        if (this.defaultOwners != null && !this.corpusColumns.hasColumn(FieldKey.OWNERS)) {
            ficheImportBuilder.getFicheChangeBuilder().putOwners(this.defaultOwners);
        }
        if ((creationDateIndex = this.corpusColumns.getCreationDateIndex()) != -1 && columnCount > creationDateIndex) {
            String creationDateString = row.getColumnValue(creationDateIndex).trim();
            try {
                FuzzyDate creationDate = FuzzyDate.parse(creationDateString);
                ficheImportBuilder.setCreationDate(creationDate);
            }
            catch (ParseException die) {
                this.parseResultBuilder.wrongDate(rowNumber, creationDateString);
            }
        }
    }

    static CorpusCreationRowParser newInstance(String[] fieldArray, EditCorpusImportBuilder editCorpusImportBuilder, ParseResultBuilder parseResultBuilder, FicheParser.Parameters ficheParserParameters, PolicyProvider policyProvider, ThesaurusLangChecker thesaurusLangChecker, FicheItems defaultOwners) {
        CorpusColumns corpusColumns = CorpusColumns.parse(fieldArray, editCorpusImportBuilder, parseResultBuilder);
        return new CorpusCreationRowParser(editCorpusImportBuilder, parseResultBuilder, ficheParserParameters, corpusColumns, policyProvider, thesaurusLangChecker, defaultOwners);
    }
}

