/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers;

import java.text.ParseException;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.thesaurus.metadata.ThesaurusLangChecker;
import net.fichotheque.thesaurus.policies.PolicyProvider;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.corpus.EditCorpusImportBuilder;
import net.fichotheque.tools.importation.corpus.EditFicheImportBuilder;
import net.fichotheque.tools.importation.parsers.CorpusColumns;
import net.fichotheque.tools.importation.parsers.CorpusRowParser;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.importation.parsers.handlers.HandlerUtils;
import net.fichotheque.tools.parsers.FicheParser;
import net.mapeadores.util.primitives.FuzzyDate;

class CorpusChangeRowParser
extends CorpusRowParser {
    private final EditCorpusImportBuilder editCorpusImportBuilder;
    private final ParseResultBuilder parseResultBuilder;
    private final FicheParser.Parameters ficheParserParameters;
    private final CorpusColumns corpusColumns;
    private final PolicyProvider policyProvider;
    private final ThesaurusLangChecker thesaurusLangChecker;

    CorpusChangeRowParser(EditCorpusImportBuilder editCorpusImportBuilder, ParseResultBuilder parseResultBuilder, FicheParser.Parameters ficheParserParameters, CorpusColumns corpusColumns, PolicyProvider policyProvider, ThesaurusLangChecker thesaurusLangChecker) {
        this.editCorpusImportBuilder = editCorpusImportBuilder;
        this.parseResultBuilder = parseResultBuilder;
        this.ficheParserParameters = ficheParserParameters;
        this.corpusColumns = corpusColumns;
        this.policyProvider = policyProvider;
        this.thesaurusLangChecker = thesaurusLangChecker;
    }

    @Override
    public EditCorpusImportBuilder getCorpusImportBuilder() {
        return this.editCorpusImportBuilder;
    }

    @Override
    public void parseRow(int rowNumber, Row row) {
        int creationDateIndex;
        int idIndex = this.corpusColumns.getIdIndex();
        int columnCount = row.getColumnCount();
        if (columnCount <= idIndex) {
            this.parseResultBuilder.missingIdColumn(rowNumber);
            return;
        }
        String idString = row.getColumnValue(idIndex).trim();
        Corpus corpus = this.editCorpusImportBuilder.getCorpus();
        FicheMeta ficheMeta = null;
        try {
            int id = Integer.parseInt(idString);
            ficheMeta = corpus.getFicheMetaById(id);
            if (ficheMeta == null) {
                this.parseResultBuilder.unknownId(rowNumber, idString);
            }
        }
        catch (NumberFormatException nfe) {
            this.parseResultBuilder.notIntegerId(rowNumber, idString);
        }
        if (ficheMeta == null) {
            return;
        }
        EditFicheImportBuilder ficheImportBuilder = this.editCorpusImportBuilder.getEditFicheImportBuilder(ficheMeta);
        if (this.corpusColumns.hasFicheHandler()) {
            HandlerUtils.populate(ficheImportBuilder.getFicheChangeBuilder(), this.corpusColumns.getFicheHandlerArray(), row, corpus, this.ficheParserParameters);
        }
        if (this.corpusColumns.hasAttributeHandler()) {
            HandlerUtils.populate(ficheImportBuilder.getAttributeChangeBuilder(), this.corpusColumns.getAttributeHandlerArray(), row);
        }
        if (this.corpusColumns.hasCroisementHandler()) {
            HandlerUtils.populate(ficheImportBuilder.getLiensImportBuilder(), this.corpusColumns.getCroisementHandlers(), row, corpus, this.ficheParserParameters.getWorkingLang(), this.policyProvider, this.thesaurusLangChecker);
        }
        if ((creationDateIndex = this.corpusColumns.getCreationDateIndex()) != -1 && columnCount > creationDateIndex) {
            String creationDateString = row.getColumnValue(creationDateIndex).trim();
            try {
                FuzzyDate creationDate = FuzzyDate.parse(creationDateString);
                ficheImportBuilder.setCreationDate(creationDate);
            }
            catch (ParseException die) {
                this.parseResultBuilder.wrongDate(rowNumber, creationDateString);
            }
        }
    }

    static CorpusChangeRowParser newInstance(String[] fieldArray, EditCorpusImportBuilder corpusImportBuilder, ParseResultBuilder parseResultBuilder, FicheParser.Parameters ficheParserParameters, PolicyProvider policyProvider, ThesaurusLangChecker thesaurusLangChecker) {
        CorpusColumns corpusColumns = CorpusColumns.parse(fieldArray, corpusImportBuilder, parseResultBuilder);
        if (corpusColumns.getIdIndex() == -1) {
            parseResultBuilder.missingColumn("id");
            return null;
        }
        return new CorpusChangeRowParser(corpusImportBuilder, parseResultBuilder, ficheParserParameters, corpusColumns, policyProvider, thesaurusLangChecker);
    }
}

