/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers;

import java.util.AbstractList;
import net.fichotheque.SubsetItem;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.Tokens;
import net.fichotheque.format.formatters.AttributeFormatter;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;

public class AttributeTokenizer
implements Tokenizer {
    private final AttributeKey attributeKey;
    private final AttributeFormatter attributeFormatter;

    public AttributeTokenizer(AttributeKey attributeKey, AttributeFormatter attributeFormatter) {
        this.attributeKey = attributeKey;
        this.attributeFormatter = attributeFormatter;
    }

    @Override
    public Tokens tokenize(FormatSource formatSource) {
        SubsetItem subsetItem = formatSource.getSubsetItemPointeur().getCurrentSubsetItem();
        Attribute attribute = subsetItem.getAttributes().getAttribute(this.attributeKey);
        if (attribute == null) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        return new InternalTokens(attribute, this.attributeFormatter, formatSource);
    }

    private static class InternalTokens
    extends AbstractList<String>
    implements Tokens {
        private final Attribute attribute;
        private final AttributeFormatter attributeFormatter;
        private final FormatSource formatSource;

        private InternalTokens(Attribute attribute, AttributeFormatter attributeFormatter, FormatSource formatSource) {
            this.attribute = attribute;
            this.attributeFormatter = attributeFormatter;
            this.formatSource = formatSource;
        }

        @Override
        public int size() {
            return this.attribute.size();
        }

        @Override
        public String get(int i) {
            return this.attributeFormatter.formatAttributeValue((String)this.attribute.get(i), i, this.formatSource);
        }
    }
}

