/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fichotheque.extraction.FilterParameters;
import net.mapeadores.util.text.StringUtils;

public class FilterParametersBuilder {
    private final Map<String, List<String>> map = new HashMap<String, List<String>>();

    public FilterParametersBuilder appendValue(String name, String value) {
        if (value == null) {
            return this;
        }
        if ((value = value.trim()).isEmpty()) {
            return this;
        }
        this.getList(name).add(value);
        return this;
    }

    public FilterParametersBuilder appendValues(String name, Collection<String> values) {
        List<String> list = this.getList(name);
        for (String value : values) {
            if (value == null || (value = value.trim()).isEmpty()) continue;
            list.add(value);
        }
        return this;
    }

    private List<String> getList(String name) {
        List<String> list = this.map.get(name);
        if (list == null) {
            list = new ArrayList<String>();
            this.map.put(name, list);
        }
        return list;
    }

    public FilterParameters toFilterParameters() {
        HashMap<String, List<String>> finalMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.map.entrySet()) {
            List<String> finalList = StringUtils.toList((Collection<String>)entry.getValue());
            if (finalList.isEmpty()) continue;
            finalMap.put(entry.getKey(), finalList);
        }
        return new InternalFilterParameters(finalMap);
    }

    public static FilterParametersBuilder init() {
        return new FilterParametersBuilder();
    }

    private static class InternalFilterParameters
    implements FilterParameters {
        private final Map<String, List<String>> map;

        private InternalFilterParameters(Map<String, List<String>> map) {
            this.map = map;
        }

        @Override
        public boolean hasParameters() {
            return !this.map.isEmpty();
        }

        @Override
        public Set<String> getParameterNameSet() {
            return Collections.unmodifiableSet(this.map.keySet());
        }

        @Override
        public List<String> getParameter(String name) {
            List<String> list = this.map.get(name);
            if (list != null) {
                return list;
            }
            return StringUtils.EMPTY_STRINGLIST;
        }
    }
}

