/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table;

import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.fichotheque.Subset;
import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.format.SourceLabelProvider;
import net.fichotheque.utils.TableDefUtils;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.money.Amount;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.table.TableWriter;

public class CsvTableWriter
implements TableWriter {
    private final ColDef[] colDefArray;
    private final Appendable appendable;
    private final DecimalFormatSymbols symbols;
    private final boolean[] hiddenArray;
    private int rowNumber;
    private int columnNumber;
    private boolean firstCell;

    public CsvTableWriter(List<ColDef> colDefList, Appendable appendable, Locale formatLocale) {
        this.appendable = appendable;
        this.symbols = new DecimalFormatSymbols(formatLocale);
        this.rowNumber = 0;
        int colLength = colDefList.size();
        this.colDefArray = new ColDef[colLength];
        this.hiddenArray = new boolean[colLength];
        int p = 0;
        Iterator<ColDef> iterator = colDefList.iterator();
        while (iterator.hasNext()) {
            ColDef colDef;
            this.colDefArray[p] = colDef = iterator.next();
            this.hiddenArray[p] = TableDefUtils.isFormula(colDef);
            ++p;
        }
    }

    public void appendColumnTitleHeader(Lang workingLang, SourceLabelProvider sourceLabelProvider, Subset referenceSubset) {
        if (this.rowNumber > 0) {
            this.appendNewLine();
        }
        ++this.rowNumber;
        try {
            int colLength = this.colDefArray.length;
            boolean next = false;
            for (int i = 0; i < colLength; ++i) {
                ColDef colDef = this.colDefArray[i];
                if (this.hiddenArray[i]) continue;
                if (next) {
                    this.appendable.append(",");
                } else {
                    next = true;
                }
                this.appendable.append("\"");
                String colTitle = TableDefUtils.getColTitle(colDef, workingLang, sourceLabelProvider, referenceSubset);
                int length = colTitle.length();
                block6: for (int j = 0; j < length; ++j) {
                    char carac = colTitle.charAt(j);
                    switch (carac) {
                        case '\"': {
                            this.appendable.append("\"\"");
                            continue block6;
                        }
                        default: {
                            this.appendable.append(carac);
                        }
                    }
                }
                this.appendable.append("\"");
            }
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
    }

    public void appendColumnKeyHeader() {
        if (this.rowNumber > 0) {
            this.appendNewLine();
        }
        ++this.rowNumber;
        try {
            int colLength = this.colDefArray.length;
            boolean next = false;
            for (int i = 0; i < colLength; ++i) {
                ColDef colDef = this.colDefArray[i];
                if (this.hiddenArray[i]) continue;
                if (next) {
                    this.appendable.append(",");
                } else {
                    next = true;
                }
                this.appendable.append(colDef.getColName());
            }
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
    }

    @Override
    public int startRow() {
        if (this.rowNumber > 0) {
            this.appendNewLine();
        }
        ++this.rowNumber;
        this.columnNumber = 0;
        this.firstCell = true;
        return this.rowNumber;
    }

    @Override
    public int addIntegerCell(Long lg) {
        if (!this.testCell()) {
            return this.columnNumber;
        }
        if (lg != null) {
            try {
                this.appendable.append(String.valueOf(lg));
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
        }
        return this.columnNumber;
    }

    @Override
    public int addDecimalCell(Decimal decimal) {
        if (!this.testCell()) {
            return this.columnNumber;
        }
        if (decimal != null) {
            try {
                this.appendable.append(String.valueOf(decimal.toString()));
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
        }
        return this.columnNumber;
    }

    @Override
    public int addStringCell(String s) {
        if (!this.testCell()) {
            return this.columnNumber;
        }
        if (s != null) {
            this.startQuote();
            int length = s.length();
            try {
                block7: for (int i = 0; i < length; ++i) {
                    char carac = s.charAt(i);
                    switch (carac) {
                        case '\"': {
                            this.appendable.append("\"\"");
                            continue block7;
                        }
                        case '\r': {
                            if (i < length - 1 && s.charAt(i + 1) == '\n') {
                                ++i;
                            }
                        }
                        case '\n': {
                            this.appendable.append("\r\n");
                            continue block7;
                        }
                        default: {
                            this.appendable.append(carac);
                        }
                    }
                }
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            this.endQuote();
        }
        return this.columnNumber;
    }

    @Override
    public int addDateCell(FuzzyDate date) {
        if (!this.testCell()) {
            return this.columnNumber;
        }
        if (date != null) {
            try {
                this.appendable.append(date.toISOString());
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
        }
        return this.columnNumber;
    }

    @Override
    public int addMoneyCell(Amount amount) {
        if (!this.testCell()) {
            return this.columnNumber;
        }
        if (amount != null) {
            this.startQuote();
            try {
                this.appendable.append(amount.toLitteralString(this.symbols, false));
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            this.endQuote();
        }
        return this.columnNumber;
    }

    @Override
    public int addPercentageCell(Decimal decimal) {
        return this.addDecimalCell(decimal);
    }

    @Override
    public int endRow() {
        return this.rowNumber;
    }

    private void appendNewLine() {
        try {
            this.appendable.append("\r\n");
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
    }

    private boolean testCell() {
        ++this.columnNumber;
        if (this.hiddenArray[this.columnNumber - 1]) {
            return false;
        }
        if (!this.firstCell) {
            try {
                this.appendable.append(",");
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
        }
        this.firstCell = false;
        return true;
    }

    private void startQuote() {
        try {
            this.appendable.append("\"");
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
    }

    private void endQuote() {
        try {
            this.appendable.append("\"");
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
    }
}

