/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.balayage;

import net.fichotheque.exportation.balayage.SiteMapOption;
import net.mapeadores.util.text.StringUtils;

public class SiteMapOptionBuilder {
    private static final String DEFAULT_FILENAME = "sitemap.xml";
    private String path = "";
    private String fileName = "sitemap.xml";
    private String baseUrl = "";

    public SiteMapOptionBuilder setPath(String path) {
        this.path = StringUtils.nullTrim(path);
        return this;
    }

    public SiteMapOptionBuilder setFileName(String fileName) {
        this.fileName = StringUtils.nullTrim(fileName);
        return this;
    }

    public SiteMapOptionBuilder setBaseUrl(String baseUrl) {
        this.baseUrl = StringUtils.nullTrim(baseUrl);
        return this;
    }

    public SiteMapOption toSiteMapOption() {
        if (this.fileName.isEmpty()) {
            this.fileName = DEFAULT_FILENAME;
        }
        return new InternalSiteMapOption(this.path, this.fileName, this.baseUrl);
    }

    public static SiteMapOptionBuilder init() {
        return new SiteMapOptionBuilder();
    }

    private static class InternalSiteMapOption
    implements SiteMapOption {
        private final String path;
        private final String fileName;
        private final String baseUrl;

        private InternalSiteMapOption(String path, String fileName, String baseUrl) {
            this.path = path;
            this.fileName = fileName;
            this.baseUrl = baseUrl;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public String getBaseUrl() {
            return this.baseUrl;
        }
    }
}

