/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.json;

import java.io.IOException;
import net.fichotheque.Fichotheque;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Info;
import net.fichotheque.corpus.fiche.ParaItem;
import net.fichotheque.corpus.fiche.Prop;
import net.fichotheque.corpus.fiche.Section;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.syntax.FicheblockSyntax;
import net.fichotheque.syntax.FormSyntax;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.SeparatorOptions;

public final class FicheJson {
    private FicheJson() {
    }

    public static void properties(JSONWriter jsonWriter, Corpus corpus, FicheAPI fiche) throws IOException {
        FicheItems owners;
        Lang lang;
        Fichotheque fichotheque = corpus.getFichotheque();
        CorpusMetadata corpusMetadata = corpus.getCorpusMetadata();
        jsonWriter.key("title");
        jsonWriter.value(fiche.getTitle());
        ParaItem subtitle = fiche.getSubtitle();
        if (subtitle != null) {
            jsonWriter.key("subtitle");
            jsonWriter.value(FormSyntax.toString(subtitle, fichotheque, null));
        }
        if ((lang = fiche.getLang()) != null) {
            jsonWriter.key("lang");
            jsonWriter.value(lang.toString());
        }
        if ((owners = fiche.getOwners()) != null) {
            jsonWriter.key("owners");
            jsonWriter.value(FormSyntax.toString(owners, fichotheque, FormSyntax.DEFAULT_INLINE_SEPARATOROPTIONS, null));
        }
        for (Prop prop : fiche.getPropList()) {
            jsonWriter.key(prop.getFieldKey().getKeyString());
            jsonWriter.value(FormSyntax.toString(prop.getFicheItem(), fichotheque, null));
        }
        for (Info info : fiche.getInfoList()) {
            FieldKey infoFieldKey = info.getFieldKey();
            SeparatorOptions separatorOptions = FormSyntax.DEFAULT_INLINE_SEPARATOROPTIONS;
            CorpusField corpusField = corpusMetadata.getCorpusField(infoFieldKey);
            if (corpusField != null && corpusField.isBlockDisplayInfoField()) {
                separatorOptions = FormSyntax.DEFAULT_BLOCK_SEPARATOROPTIONS;
            }
            jsonWriter.key(infoFieldKey.getKeyString());
            jsonWriter.value(FormSyntax.toString(info, fichotheque, separatorOptions, null));
        }
        FicheblockSyntax.Parameters ficheBlockFormSyntaxParameters = FicheblockSyntax.parameters().withSpecialParseChars(true);
        for (Section section : fiche.getSectionList()) {
            jsonWriter.key(section.getFieldKey().getKeyString());
            jsonWriter.value(FicheblockSyntax.toString(section, ficheBlockFormSyntaxParameters));
        }
    }
}

