/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.corpus.metadata;

import java.text.ParseException;
import java.util.Set;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.MultiStringable;
import net.mapeadores.util.text.StringUtils;

public interface CorpusField {
    public static final String ITEM_FIELD = "item";
    public static final String PERSON_FIELD = "person";
    public static final String LANGUAGE_FIELD = "language";
    public static final String COUNTRY_FIELD = "country";
    public static final String DATE_FIELD = "date";
    public static final String EMAIL_FIELD = "email";
    public static final String LINK_FIELD = "link";
    public static final String NUMBER_FIELD = "number";
    public static final String AMOUNT_FIELD = "amount";
    public static final String GEOPOINT_FIELD = "geopoint";
    public static final String PARA_FIELD = "para";
    public static final String IMAGE_FIELD = "image";

    public FieldKey getFieldKey();

    public Labels getLabels();

    public Set<String> getOptionNameSet();

    public Object getOption(String var1);

    public CorpusMetadata getCorpusMetadata();

    public String getFicheItemType();

    public boolean isGenerated();

    default public boolean isSpecial() {
        return this.getFieldKey().isSpecial();
    }

    default public boolean isProp() {
        return this.getFieldKey().isProp();
    }

    default public boolean isInfo() {
        return this.getFieldKey().isInfo();
    }

    default public boolean isSection() {
        return this.getFieldKey().isSection();
    }

    default public String getFieldName() {
        return this.getFieldKey().getFieldName();
    }

    default public String getFieldString() {
        return this.getFieldKey().getKeyString();
    }

    default public short getCategory() {
        return this.getFieldKey().getCategory();
    }

    default public String getCategoryString() {
        return FieldKey.categoryToString(this.getFieldKey().getCategory());
    }

    default public String getStringOption(String optionName) {
        return (String)this.getOption(optionName);
    }

    default public boolean isBlockDisplayInfoField() {
        if (!this.isInfo()) {
            return false;
        }
        String value = this.getStringOption("infoDisplay");
        if (value == null) {
            return false;
        }
        return value.equals("block");
    }

    default public boolean isType(String ficheItemType) {
        return this.getFicheItemType().equals(ficheItemType);
    }

    default public String getLangScope() {
        if (!this.isType(LANGUAGE_FIELD)) {
            return null;
        }
        String value = this.getStringOption("langScope");
        if (value == null) {
            return CorpusMetadataUtils.getDefaultLangScope(this.getFieldKey());
        }
        return value;
    }

    default public boolean isSubfieldDisplay() {
        String value = this.getStringOption("subfieldDisplay");
        return StringUtils.isTrue(value);
    }

    default public SubsetKey getDefaultSphereKey() {
        String value = this.getStringOption("defaultSphereKey");
        if (value == null) {
            return null;
        }
        try {
            SubsetKey sphereKey = SubsetKey.parse(value);
            if (!sphereKey.isSphereSubset()) {
                return null;
            }
            return sphereKey;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    default public Currencies getCurrencies() {
        Object value = this.getOption("currencyArray");
        if (value == null) {
            return null;
        }
        return (Currencies)value;
    }

    default public Langs getLangs() {
        Object value = this.getOption("langArray");
        if (value == null) {
            return null;
        }
        return (Langs)value;
    }

    default public MultiStringable getAddressFieldNames() {
        Object value = this.getOption("addressFieldArray");
        if (value == null) {
            return null;
        }
        return (MultiStringable)value;
    }

    public static String checkFicheItemType(String ficheItemType) {
        switch (ficheItemType) {
            case "person": 
            case "personne": {
                return PERSON_FIELD;
            }
            case "language": 
            case "langue": {
                return LANGUAGE_FIELD;
            }
            case "date": 
            case "datation": {
                return DATE_FIELD;
            }
            case "country": 
            case "pays": {
                return COUNTRY_FIELD;
            }
            case "email": 
            case "courriel": {
                return EMAIL_FIELD;
            }
            case "link": {
                return LINK_FIELD;
            }
            case "item": {
                return ITEM_FIELD;
            }
            case "number": 
            case "nombre": {
                return NUMBER_FIELD;
            }
            case "amount": 
            case "montant": {
                return AMOUNT_FIELD;
            }
            case "geopoint": {
                return GEOPOINT_FIELD;
            }
            case "para": {
                return PARA_FIELD;
            }
            case "image": {
                return IMAGE_FIELD;
            }
        }
        throw new IllegalArgumentException("Wrong ficheItemType value : " + ficheItemType);
    }
}

