/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.corpus.fiche;

import java.io.Serializable;
import net.fichotheque.corpus.fiche.Atts;

class AttsImpl
implements Atts,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Atts EMPTY_ATTS = new EmptyAtts();
    private int size = 0;
    private String[] nameArray = new String[4];
    private String[] valueArray = new String[4];

    AttsImpl() {
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String getName(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.nameArray[index];
    }

    @Override
    public String getValue(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.valueArray[index];
    }

    void put(String name, String value) {
        if (value == null) {
            value = "";
        }
        for (int i = 0; i < this.size; ++i) {
            if (!this.nameArray[i].equals(name)) continue;
            this.valueArray[i] = value;
            return;
        }
        this.checkLength();
        this.nameArray[this.size] = name;
        this.valueArray[this.size] = value;
        ++this.size;
    }

    private void checkLength() {
        if (this.size == this.nameArray.length) {
            String[] nvName = new String[this.size * 2];
            System.arraycopy(this.nameArray, 0, nvName, 0, this.size);
            this.nameArray = nvName;
            String[] nvValue = new String[this.size * 2];
            System.arraycopy(this.valueArray, 0, nvValue, 0, this.size);
            this.valueArray = nvValue;
        }
    }

    private String getSyntax() {
        for (int i = 0; i < this.size; ++i) {
            switch (this.nameArray[i]) {
                case "mode": 
                case "syntax": {
                    return this.valueArray[i];
                }
            }
        }
        return "";
    }

    static String getSyntax(AttsImpl impl) {
        if (impl == null) {
            return "";
        }
        return impl.getSyntax();
    }

    static Atts check(AttsImpl impl) {
        if (impl == null) {
            return EMPTY_ATTS;
        }
        return impl;
    }

    static AttsImpl put(AttsImpl impl, String name, String value) {
        if (impl == null) {
            impl = new AttsImpl();
        }
        impl.put(name, value);
        return impl;
    }

    private static class EmptyAtts
    implements Atts {
        private EmptyAtts() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public String getName(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public String getValue(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }
}

