/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.xml.dyn;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.namespaces.RoleSpace;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.api.users.BdfUser;
import java.io.IOException;
import net.fichotheque.Subset;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class UserXMLPart
extends XMLPart {
    private final BdfServer bdfServer;
    private final BdfUser bdfUser;
    private final PermissionSummary permissionSummary;

    public UserXMLPart(XMLWriter xmlWriter, BdfServer bdfServer, BdfUser bdfUser, PermissionSummary permissionSummary) {
        super(xmlWriter);
        this.bdfServer = bdfServer;
        this.bdfUser = bdfUser;
        this.permissionSummary = permissionSummary;
    }

    public void start() throws IOException {
        Redacteur redacteur = this.bdfUser.getRedacteur();
        this.startOpenTag("user");
        this.addAttribute("sphere", redacteur.getSubsetName());
        this.addAttribute("id", redacteur.getId());
        this.addAttribute("login", redacteur.getLogin());
        this.endOpenTag();
    }

    public void addCorpusUi(Corpus corpus) throws IOException {
        boolean hideMaster = this.hideMaster(corpus);
        this.startOpenTag("ui");
        this.addAttribute("corpus", corpus.getSubsetName());
        this.endOpenTag();
        if (!this.permissionSummary.hasAccess(corpus)) {
            this.addEmptyElement("deny");
            this.closeTag("ui");
            return;
        }
        UiComponents mainUiComponents = this.bdfServer.getUiManager().getMainUiComponents(corpus);
        for (UiComponent uiComponent : mainUiComponents.getUiComponentList()) {
            SubsetIncludeUi includeUi;
            if (!(uiComponent instanceof SubsetIncludeUi) || !this.testHide((includeUi = (SubsetIncludeUi)uiComponent).getExtendedIncludeKey(), hideMaster, includeUi.getAttributes())) continue;
            this.startOpenTag("hide");
            this.addAttribute("name", uiComponent.getName());
            this.closeEmptyTag();
        }
        this.closeTag("ui");
    }

    public void end() throws IOException {
        this.closeTag("user");
    }

    private boolean hideMaster(Corpus corpus) {
        Subset subset = corpus.getMasterSubset();
        if (subset == null) {
            return false;
        }
        return !this.permissionSummary.hasAccess(subset.getSubsetKey());
    }

    private boolean testHide(ExtendedIncludeKey includeKey, boolean hideMaster, Attributes attributes) {
        if (!this.permissionSummary.hasAccess(includeKey.getSubsetKey())) {
            return true;
        }
        if (includeKey.isMaster() && hideMaster) {
            return true;
        }
        return !RoleSpace.canRead(this.permissionSummary, attributes);
    }

    public static void writeDefaultUser(XMLWriter xmlWriter) throws IOException {
        xmlWriter.startOpenTag("user");
        xmlWriter.endOpenTag();
        xmlWriter.closeTag("user");
    }
}

