/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.subsettree;

import fr.exemole.bdfserver.api.subsettree.CroisementSubsetNode;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.croisement.Croisements;

public class CroisementSubsetNodeBuilder {
    private final Subset subset;
    private final Croisements croisements;

    public CroisementSubsetNodeBuilder(Subset subset, Croisements croisements) {
        if (subset == null) {
            throw new IllegalArgumentException("subset is null");
        }
        if (croisements == null) {
            throw new IllegalArgumentException("croisements is null");
        }
        this.subset = subset;
        this.croisements = croisements;
    }

    public CroisementSubsetNode toCroisementSubsetNode() {
        return new InternalCroisementSubsetNode(this.subset, this.croisements);
    }

    public CroisementSubsetNodeBuilder init(Subset subset, Croisements croisements) {
        return new CroisementSubsetNodeBuilder(subset, croisements);
    }

    public static CroisementSubsetNode build(Subset subset, Croisements croisements) {
        if (subset == null) {
            throw new IllegalArgumentException("subset is null");
        }
        if (croisements == null) {
            throw new IllegalArgumentException("croisements is null");
        }
        return new InternalCroisementSubsetNode(subset, croisements);
    }

    private static class InternalCroisementSubsetNode
    implements CroisementSubsetNode {
        private final Subset subset;
        private final Croisements croisements;

        private InternalCroisementSubsetNode(Subset subset, Croisements croisements) {
            this.subset = subset;
            this.croisements = croisements;
        }

        @Override
        public SubsetKey getSubsetKey() {
            return this.subset.getSubsetKey();
        }

        @Override
        public Subset getSubset() {
            return this.subset;
        }

        @Override
        public Croisements getCroisements() {
            return this.croisements;
        }
    }
}

