/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.memento;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.managers.TransformationManager;
import fr.exemole.bdfserver.api.memento.MementoNode;
import fr.exemole.bdfserver.api.memento.MementoUnit;
import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.exportation.transformation.TransformerParameters;
import fr.exemole.bdfserver.tools.memento.MementoNodeBuilder;
import fr.exemole.bdfserver.tools.memento.MementoUtils;
import fr.exemole.bdfserver.tools.memento.dom.MementoTreeDOMReader;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.transform.dom.DOMSource;
import net.fichotheque.exportation.transformation.SimpleTemplate;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.mapeadores.util.exceptions.NestedTransformerException;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.io.ResourceFolder;
import net.mapeadores.util.io.ResourceStorage;
import net.mapeadores.util.io.ResourceStorages;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MementoEngine {
    private static final RelativePath CORE_PATH = RelativePath.build("xml/memento");
    private static final Lang ENGLISH = Lang.build("en");
    private static final Lang FRENCH = Lang.build("fr");
    private final BdfParameters bdfParameters;
    private final BdfServer bdfServer;
    private final BdfUser bdfUser;
    private final ResourceStorages resourceStorages;

    private MementoEngine(BdfParameters bdfParameters) {
        this.bdfParameters = bdfParameters;
        this.bdfServer = bdfParameters.getBdfServer();
        this.bdfUser = bdfParameters.getBdfUser();
        this.resourceStorages = this.bdfServer.getResourceStorages();
    }

    public static List<MementoUnit.Info> getMementoUnitInfoList(BdfParameters bdfParameters) {
        MementoEngine mementoEngine = new MementoEngine(bdfParameters);
        return mementoEngine.scanMementoUnitInfoList();
    }

    public static MementoUnit getMementoUnit(BdfParameters bdfParameters, RelativePath path) {
        MementoEngine mementoEngine = new MementoEngine(bdfParameters);
        return mementoEngine.getMementoUnit(path);
    }

    private MementoUnit getMementoUnit(RelativePath path) {
        Document treeDocument;
        try {
            treeDocument = this.getUnitTreeDocument(path);
            if (treeDocument == null) {
                return MementoEngine.getErrorUnit(path, "Error: missing tree.xml");
            }
        }
        catch (SAXException saxe) {
            return MementoEngine.getErrorUnit(path, "Error: invalid tree.xml / " + saxe.getMessage());
        }
        UnitScan unitScan = new UnitScan(path);
        for (ResourceStorage resourceStorage : this.resourceStorages) {
            ResourceFolder folder = resourceStorage.getResourceFolder(path);
            if (folder == null) continue;
            unitScan.scan(folder);
        }
        TemplateKey templateKey = BdfUserUtils.getSimpleTemplateKey(this.bdfParameters, TransformationKey.MEMENTO_INSTANCE);
        TransformationManager transformationManager = this.bdfServer.getTransformationManager();
        SimpleTemplate simpleTemplate = transformationManager.getSimpleTemplate(templateKey, true);
        return unitScan.toUnit(this.bdfUser.getLangPreference(), MementoTreeDOMReader.readNode(treeDocument.getDocumentElement()), simpleTemplate);
    }

    private List<MementoUnit.Info> scanMementoUnitInfoList() {
        LangPreference langPreference = this.bdfUser.getLangPreference();
        ArrayList<MementoUnit.Info> result = new ArrayList<MementoUnit.Info>();
        TreeMap<String, SourceScan> scanMap = new TreeMap<String, SourceScan>();
        for (ResourceStorage resourceStorage : this.resourceStorages) {
            this.scanResourceStorage(resourceStorage, scanMap);
        }
        for (SourceScan scan : scanMap.values()) {
            scan.populate(result, langPreference);
        }
        return result;
    }

    private void scanResourceStorage(ResourceStorage resourceStorage, SortedMap<String, SourceScan> scanMap) {
        ResourceFolder extrscFolder;
        ResourceFolder coreFolder = resourceStorage.getResourceFolder(CORE_PATH);
        if (coreFolder != null) {
            SourceScan scan = (SourceScan)scanMap.get("");
            if (scan == null) {
                scan = new SourceScan("", CORE_PATH);
                scanMap.put("", scan);
            }
            scan.scanUnit(coreFolder);
        }
        if ((extrscFolder = resourceStorage.getResourceFolder(StorageUtils.EXTENSION_RESOURCE_ROOT)) != null) {
            for (ResourceFolder subfolder : extrscFolder.getSubfolderList()) {
                String name = subfolder.getName();
                RelativePath path = StorageUtils.EXTENSION_RESOURCE_ROOT.buildChild(name + "/xml/memento");
                ResourceFolder extFolder = resourceStorage.getResourceFolder(path);
                if (extFolder == null) continue;
                SourceScan scan = (SourceScan)scanMap.get(name);
                if (scan == null) {
                    scan = new SourceScan(name, path);
                    scanMap.put(name, scan);
                }
                scan.scanUnit(extFolder);
            }
        }
    }

    private Document getUnitTreeDocument(RelativePath unitRelativePath) throws SAXException {
        DocStream docStream = this.bdfServer.getResourceStorages().getResourceDocStream(unitRelativePath.buildChild("tree.xml"));
        if (docStream == null) {
            return null;
        }
        try {
            return DOMUtils.parseDocument(docStream);
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    private List<String> getOrderedNameList(RelativePath sourceRelativePath) {
        ArrayList<String> result = new ArrayList<String>();
        DocStream docStream = this.bdfServer.getResourceStorages().getResourceDocStream(sourceRelativePath.buildChild("order.txt"));
        if (docStream != null) {
            try (BufferedReader reader = new BufferedReader(docStream.getReader());){
                String ligne;
                while ((ligne = reader.readLine()) != null) {
                    if ((ligne = ligne.trim()).length() <= 0 || ligne.startsWith("#")) continue;
                    result.add(ligne);
                }
            }
            catch (IOException ioe) {
                throw new BdfStorageException(ioe);
            }
        }
        return result;
    }

    private static MementoUnit getErrorUnit(RelativePath path, String title) {
        return new InternalMementoUnit(path, title, MementoUtils.EMPTY_NODELIST);
    }

    private class UnitScan {
        private final String name;
        private final RelativePath unitPath;
        private final Set<Lang> availableLangSet = new HashSet<Lang>();

        private UnitScan(RelativePath unitPath) {
            this.name = unitPath.getLastName();
            this.unitPath = unitPath;
        }

        private void scan(ResourceFolder unitFolder) {
            for (ResourceFolder langFolder : unitFolder.getSubfolderList()) {
                try {
                    Lang lang = Lang.parse(langFolder.getName());
                    this.availableLangSet.add(lang);
                }
                catch (ParseException parseException) {}
            }
        }

        private MementoUnit.Info toInfo(LangPreference langPreference) {
            String title = this.testTreeFile();
            if (title == null) {
                title = this.getUnitTitle(langPreference);
            }
            return new InternalInfo(this.name, this.unitPath, title);
        }

        private MementoUnit toUnit(LangPreference langPreference, MementoTreeDOMReader.Node rootNode, SimpleTemplate simpleTemplate) {
            String title = this.getUnitTitle(langPreference);
            ArrayList<MementoNode> nodeList = new ArrayList<MementoNode>();
            for (MementoTreeDOMReader.Node subnode : rootNode.getSubnodeList()) {
                nodeList.add(this.toMementoNode(langPreference, subnode, simpleTemplate));
            }
            return new InternalMementoUnit(this.unitPath, title, nodeList);
        }

        private MementoNode toMementoNode(LangPreference langPreference, MementoTreeDOMReader.Node elNode, SimpleTemplate simpleTemplate) {
            MementoNodeBuilder builder = new MementoNodeBuilder(elNode.getName());
            for (MementoTreeDOMReader.Node subnode : elNode.getSubnodeList()) {
                builder.addSubnode(this.toMementoNode(langPreference, subnode, simpleTemplate));
            }
            DocumentInfo documentInfo = this.getNodeDocumentInfo(langPreference, elNode.getName());
            if (documentInfo != null) {
                builder.setTitle(documentInfo.getTitle());
                builder.setText(documentInfo.transform(simpleTemplate));
            } else {
                builder.setTitle("Missing */" + elNode.getName() + ".xml");
            }
            return builder.toMementoNode();
        }

        private String getUnitTitle(LangPreference langPreference) {
            DocumentInfo documentInfo = this.getNodeDocumentInfo(langPreference, this.name);
            if (documentInfo != null) {
                return documentInfo.getTitle();
            }
            return this.name;
        }

        private String testTreeFile() {
            try {
                Document document = MementoEngine.this.getUnitTreeDocument(this.unitPath);
                if (document == null) {
                    return "Error: missing tree.xml";
                }
            }
            catch (SAXException sax) {
                return "Error: invalid tree.xml / " + sax.getMessage();
            }
            return null;
        }

        private DocumentInfo getNodeDocumentInfo(LangPreference langPreference, String nodeName) {
            DocumentInfo documentInfo;
            block6: {
                documentInfo = null;
                for (Lang lang : langPreference) {
                    documentInfo = this.getNodeDocumentInfo(lang, nodeName);
                    if (documentInfo == null && !lang.isRootLang()) {
                        documentInfo = this.getNodeDocumentInfo(lang.getRootLang(), nodeName);
                    }
                    if (documentInfo == null) continue;
                    break;
                }
                if (documentInfo != null) break block6;
                if (this.availableLangSet.contains(ENGLISH)) {
                    documentInfo = this.getNodeDocumentInfo(ENGLISH, nodeName);
                }
                if (documentInfo == null && this.availableLangSet.contains(FRENCH)) {
                    documentInfo = this.getNodeDocumentInfo(FRENCH, nodeName);
                }
                if (documentInfo == null) {
                    Lang lang;
                    Iterator<Object> iterator = this.availableLangSet.iterator();
                    while (iterator.hasNext() && (documentInfo = this.getNodeDocumentInfo(lang = (Lang)iterator.next(), nodeName)) == null) {
                    }
                }
            }
            return documentInfo;
        }

        private DocumentInfo getNodeDocumentInfo(Lang lang, String nodeName) {
            DocStream docStream = MementoEngine.this.bdfServer.getResourceStorages().getResourceDocStream(this.unitPath.buildChild(lang.toString() + "/" + nodeName + ".xml"));
            if (docStream == null) {
                return null;
            }
            try {
                Document document = DOMUtils.parseDocument(docStream);
                return new DocumentInfo(lang, this.name, document);
            }
            catch (IOException | SAXException e) {
                return new DocumentInfo(lang, this.name, e.getMessage());
            }
        }
    }

    private class SourceScan {
        private final String name;
        private final RelativePath relativePath;
        private final SortedMap<String, UnitScan> unitScanMap = new TreeMap<String, UnitScan>();

        private SourceScan(String name, RelativePath relativePath) {
            this.name = name;
            this.relativePath = relativePath;
        }

        private void scanUnit(ResourceFolder sourceFolder) {
            for (ResourceFolder subfolder : sourceFolder.getSubfolderList()) {
                String name = subfolder.getName();
                UnitScan current = (UnitScan)this.unitScanMap.get(name);
                if (current == null) {
                    current = new UnitScan(this.relativePath.buildChild(name));
                    this.unitScanMap.put(name, current);
                }
                current.scan(subfolder);
            }
        }

        private void populate(List<MementoUnit.Info> list, LangPreference langPreference) {
            List orderedNameList = MementoEngine.this.getOrderedNameList(this.relativePath);
            for (String name : orderedNameList) {
                UnitScan unitScan = (UnitScan)this.unitScanMap.get(name);
                if (unitScan == null) continue;
                this.unitScanMap.remove(name);
                list.add(unitScan.toInfo(langPreference));
            }
            for (UnitScan unitScan : this.unitScanMap.values()) {
                list.add(unitScan.toInfo(langPreference));
            }
        }
    }

    private static class InternalMementoUnit
    implements MementoUnit {
        private final RelativePath relativePath;
        private final String title;
        private List<MementoNode> nodeList;

        private InternalMementoUnit(RelativePath relativePath, String title, List<MementoNode> nodeList) {
            this.relativePath = relativePath;
            this.title = title;
            this.nodeList = nodeList;
        }

        @Override
        public String getName() {
            return this.relativePath.getLastName();
        }

        @Override
        public RelativePath getPath() {
            return this.relativePath;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public boolean isLeaf() {
            return this.nodeList.isEmpty();
        }

        @Override
        public List<MementoNode> getSubnodeList() {
            return this.nodeList;
        }

        @Override
        public String getText() {
            return "";
        }
    }

    private static class DocumentInfo {
        private final Lang lang;
        private final String name;
        private final Document document;
        private final String errorMessage;

        private DocumentInfo(Lang lang, String name, Document document) {
            this.lang = lang;
            this.name = name;
            this.document = document;
            this.errorMessage = null;
        }

        private DocumentInfo(Lang lang, String name, String errorMessage) {
            this.lang = lang;
            this.name = name;
            this.document = null;
            this.errorMessage = errorMessage;
        }

        private String transform(SimpleTemplate simpleTemplate) {
            if (this.errorMessage != null) {
                return "";
            }
            try {
                TransformerParameters transformerParameters = TransformerParameters.build(this.lang).check(simpleTemplate.getAttributes());
                return simpleTemplate.transform(new DOMSource(this.document.getDocumentElement()), transformerParameters.getMap());
            }
            catch (NestedTransformerException nte) {
                Throwable throwable = nte.getCause();
                return throwable.getClass().getName() + ": " + throwable.getMessage();
            }
        }

        private String getTitle() {
            if (this.errorMessage != null) {
                return this.lang.toString() + "/" + this.name + ".xml / " + this.errorMessage;
            }
            NodeList nodeList = this.document.getDocumentElement().getChildNodes();
            int length = nodeList.getLength();
            for (int i = 0; i < length; ++i) {
                String title;
                Element el;
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !(el = (Element)node).getTagName().equals("title") || (title = DOMUtils.readSimpleElement(el)).isEmpty()) continue;
                return title;
            }
            return null;
        }
    }

    private static class InternalInfo
    implements MementoUnit.Info {
        private final String name;
        private final RelativePath path;
        private final String title;

        private InternalInfo(String name, RelativePath path, String title) {
            this.name = name;
            this.path = path;
            this.title = title;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public RelativePath getPath() {
            return this.path;
        }

        @Override
        public String getTitle() {
            return this.title;
        }
    }
}

